/*
 * Decompiled with CFR 0.152.
 */
package org.keyczar.interop;

import org.json.JSONException;
import org.json.JSONObject;
import org.keyczar.exceptions.KeyczarException;
import org.keyczar.interop.Creator;
import org.keyczar.interop.Generator;
import org.keyczar.interop.InteropCommand;
import org.keyczar.interop.Tester;

public class Interop {
    public static void main(String[] args) {
        switch (Interop.getCommandType(args[0])) {
            case GENERATE: {
                Generator generator = Generator.read(args[0]);
                try {
                    String output = generator.generate();
                    if (output == null) break;
                    System.out.print(output);
                }
                catch (KeyczarException e) {
                    e.printStackTrace();
                    System.exit(1);
                }
                break;
            }
            case CREATE: {
                Creator creator = Creator.read(args[0]);
                creator.create();
                break;
            }
            case TEST: {
                Tester tester = Tester.read(args[0]);
                try {
                    tester.test();
                }
                catch (KeyczarException e) {
                    e.printStackTrace();
                    System.exit(1);
                }
                break;
            }
            default: {
                System.out.println("No such command");
                System.exit(1);
            }
        }
    }

    private static InteropCommand getCommandType(String jsonString) {
        try {
            return InteropCommand.getCommand(new JSONObject(jsonString).getString("command"));
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }
}

