/*
 * Decompiled with CFR 0.152.
 */
package org.keyczar.enums;

public enum CipherMode {
    CBC("AES/CBC/PKCS5Padding"),
    CTR("AES/CTR/NoPadding"),
    ECB("AES/ECB/NoPadding"),
    DET_CBC("AES/CBC/PKCS5Padding");

    private String jceMode;

    private CipherMode(String s) {
        this.jceMode = s;
    }

    public String getMode() {
        return this.jceMode;
    }

    public int getOutputSize(int blockSize, int inputLength) {
        if (this == CBC) {
            return (inputLength / blockSize + 2) * blockSize;
        }
        if (this == ECB) {
            return blockSize;
        }
        if (this == CTR) {
            return inputLength + blockSize / 2;
        }
        if (this == DET_CBC) {
            return (inputLength / blockSize + 1) * blockSize;
        }
        return 0;
    }
}

