/*
 * Decompiled with CFR 0.152.
 */
package org.keyczar;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import org.keyczar.Keyczar;
import org.keyczar.KeyczarKey;
import org.keyczar.StreamCache;
import org.keyczar.enums.KeyPurpose;
import org.keyczar.exceptions.BadVersionException;
import org.keyczar.exceptions.KeyNotFoundException;
import org.keyczar.exceptions.KeyczarException;
import org.keyczar.exceptions.ShortSignatureException;
import org.keyczar.interfaces.KeyczarReader;
import org.keyczar.interfaces.VerifyingStream;
import org.keyczar.util.Base64Coder;
import org.keyczar.util.Util;

public class Verifier
extends Keyczar {
    private final StreamCache<VerifyingStream> VERIFY_CACHE = new StreamCache();

    public Verifier(KeyczarReader reader) throws KeyczarException {
        super(reader);
    }

    public Verifier(String fileLocation) throws KeyczarException {
        super(fileLocation);
    }

    public boolean verify(byte[] data, byte[] signature) throws KeyczarException {
        return this.verify(ByteBuffer.wrap(data), ByteBuffer.wrap(signature));
    }

    public boolean verify(ByteBuffer data, ByteBuffer signature) throws KeyczarException {
        return this.verify(data, null, signature);
    }

    boolean verify(ByteBuffer data, ByteBuffer hidden, ByteBuffer signature) throws KeyczarException {
        if (signature.remaining() < 5) {
            throw new ShortSignatureException(signature.remaining());
        }
        byte[] hash = this.checkFormatAndGetHash(signature);
        KeyczarKey key = this.getVerifyingKey(hash);
        if (key == null) {
            throw new KeyNotFoundException(hash);
        }
        VerifyingStream stream = this.VERIFY_CACHE.get(key);
        if (stream == null) {
            stream = (VerifyingStream)key.getStream();
        }
        stream.initVerify();
        if (hidden != null) {
            stream.updateVerify(hidden);
        }
        stream.updateVerify(data);
        stream.updateVerify(ByteBuffer.wrap(FORMAT_BYTES));
        boolean result = stream.verify(signature);
        this.VERIFY_CACHE.put(key, stream);
        return result;
    }

    public boolean verify(String data, String signature) throws KeyczarException {
        try {
            return this.verify(data.getBytes("UTF-8"), Base64Coder.decodeWebSafe(signature));
        }
        catch (UnsupportedEncodingException e) {
            throw new KeyczarException(e);
        }
    }

    boolean rawVerify(KeyczarKey key, ByteBuffer data, ByteBuffer hidden, ByteBuffer signature) throws KeyczarException {
        VerifyingStream stream = this.VERIFY_CACHE.get(key);
        if (stream == null) {
            stream = (VerifyingStream)key.getStream();
        }
        stream.initVerify();
        stream.updateVerify(data);
        if (hidden != null) {
            stream.updateVerify(hidden);
        }
        stream.updateVerify(ByteBuffer.wrap(FORMAT_BYTES));
        boolean result = stream.verify(signature);
        this.VERIFY_CACHE.put(key, stream);
        return result;
    }

    public boolean attachedVerify(byte[] signedBlob, byte[] hidden) throws KeyczarException {
        ByteBuffer sigBuffer = ByteBuffer.wrap(signedBlob);
        byte[] hash = this.checkFormatAndGetHash(sigBuffer);
        KeyczarKey key = this.getVerifyingKey(hash);
        int blobSize = sigBuffer.getInt();
        byte[] blob = new byte[blobSize];
        sigBuffer.get(blob);
        int signatureSize = sigBuffer.remaining();
        byte[] signature = new byte[signatureSize];
        sigBuffer.get(signature);
        byte[] hiddenPlusLength = Util.fromInt(0);
        if (hidden.length > 0) {
            hiddenPlusLength = Util.lenPrefix(hidden);
        }
        return this.rawVerify(key, ByteBuffer.wrap(blob), ByteBuffer.wrap(hiddenPlusLength), ByteBuffer.wrap(signature));
    }

    public byte[] getAttachedData(byte[] signedBlob, byte[] hidden) throws KeyczarException {
        if (!this.attachedVerify(signedBlob, hidden)) {
            throw new KeyczarException("Attached signature failed to verify. Unable to return signed data.");
        }
        return this.getAttachedDataWithoutVerifying(signedBlob);
    }

    public byte[] getAttachedDataWithoutVerifying(byte[] signedBlob) throws KeyczarException {
        ByteBuffer sigBuffer = ByteBuffer.wrap(signedBlob);
        byte[] hash = this.checkFormatAndGetHash(sigBuffer);
        this.getVerifyingKey(hash);
        int blobSize = sigBuffer.getInt();
        byte[] blob = new byte[blobSize];
        sigBuffer.get(blob);
        return blob;
    }

    private byte[] checkFormatAndGetHash(ByteBuffer signature) throws BadVersionException {
        byte version = signature.get();
        if (version != 0) {
            throw new BadVersionException(version);
        }
        byte[] hash = new byte[4];
        signature.get(hash);
        return hash;
    }

    private KeyczarKey getVerifyingKey(byte[] hash) throws KeyNotFoundException {
        KeyczarKey key = this.getKey(hash);
        if (key == null) {
            throw new KeyNotFoundException(hash);
        }
        return key;
    }

    @Override
    boolean isAcceptablePurpose(KeyPurpose purpose) {
        return purpose == KeyPurpose.VERIFY || purpose == KeyPurpose.SIGN_AND_VERIFY;
    }
}

