/*
 * Decompiled with CFR 0.152.
 */
package org.keyczar;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import org.keyczar.Verifier;
import org.keyczar.exceptions.KeyczarException;
import org.keyczar.exceptions.ShortSignatureException;
import org.keyczar.interfaces.KeyczarReader;
import org.keyczar.util.Base64Coder;
import org.keyczar.util.Clock;
import org.keyczar.util.SystemClock;
import org.keyczar.util.Util;

public class TimeoutVerifier {
    private Verifier verifier;
    private Clock clock = new SystemClock();

    TimeoutVerifier() {
    }

    public TimeoutVerifier(KeyczarReader reader) throws KeyczarException {
        this.setVerifier(new Verifier(reader));
    }

    public TimeoutVerifier(String fileLocation) throws KeyczarException {
        this.setVerifier(new Verifier(fileLocation));
    }

    public TimeoutVerifier(Verifier verifier) {
        this.setVerifier(verifier);
    }

    void setVerifier(Verifier verifier) {
        this.verifier = verifier;
    }

    void setClock(Clock clock) {
        this.clock = clock;
    }

    public boolean verify(String data, String signature) throws KeyczarException {
        try {
            return this.verify(data.getBytes("UTF-8"), Base64Coder.decodeWebSafe(signature));
        }
        catch (UnsupportedEncodingException e) {
            throw new KeyczarException(e);
        }
    }

    public boolean verify(byte[] data, byte[] signature) throws KeyczarException {
        return this.verify(ByteBuffer.wrap(data), ByteBuffer.wrap(signature));
    }

    public boolean verify(ByteBuffer data, ByteBuffer timeoutSignature) throws KeyczarException {
        if (timeoutSignature.remaining() < 13) {
            throw new ShortSignatureException(timeoutSignature.remaining());
        }
        byte[] header = new byte[5];
        timeoutSignature.get(header);
        byte[] timestamp = new byte[8];
        timeoutSignature.get(timestamp);
        long expirationTime = Util.toLong(timestamp);
        long now = this.clock.now();
        if (now > expirationTime) {
            return false;
        }
        ByteBuffer slicedSignature = ByteBuffer.allocate(5 + timeoutSignature.remaining());
        slicedSignature.put(header);
        slicedSignature.put(timeoutSignature);
        slicedSignature.rewind();
        ByteBuffer prependedData = ByteBuffer.allocate(8 + data.remaining());
        prependedData.put(timestamp);
        prependedData.put(data);
        prependedData.rewind();
        return this.verifier.verify(prependedData, slicedSignature);
    }
}

