/*
 * Decompiled with CFR 0.152.
 */
package org.keyczar;

import org.keyczar.AesKey;
import org.keyczar.Crypter;
import org.keyczar.DefaultKeyType;
import org.keyczar.Encrypter;
import org.keyczar.ImportedKeyReader;
import org.keyczar.annotations.Experimental;
import org.keyczar.exceptions.KeyczarException;
import org.keyczar.keyparams.AesKeyParameters;

@Experimental
public class SessionCrypter {
    private final Crypter symmetricCrypter;
    private final byte[] sessionMaterial;

    public SessionCrypter(Encrypter encrypter) throws KeyczarException {
        AesKey aesKey = AesKey.generate((AesKeyParameters)DefaultKeyType.AES.applyDefaultParameters(null));
        ImportedKeyReader importedKeyReader = new ImportedKeyReader(aesKey);
        this.symmetricCrypter = new Crypter(importedKeyReader);
        this.sessionMaterial = encrypter.encrypt(aesKey.getEncoded());
    }

    public SessionCrypter(Crypter crypter, byte[] sessionMaterial) throws KeyczarException {
        byte[] packedKeys = crypter.decrypt(sessionMaterial);
        AesKey aesKey = AesKey.fromPackedKey(packedKeys);
        ImportedKeyReader importedKeyReader = new ImportedKeyReader(aesKey);
        this.symmetricCrypter = new Crypter(importedKeyReader);
        this.sessionMaterial = sessionMaterial;
    }

    public byte[] decrypt(byte[] ciphertext) throws KeyczarException {
        return this.symmetricCrypter.decrypt(ciphertext);
    }

    public byte[] encrypt(byte[] plaintext) throws KeyczarException {
        return this.symmetricCrypter.encrypt(plaintext);
    }

    public byte[] getSessionMaterial() {
        return this.sessionMaterial;
    }
}

