/*
 * Decompiled with CFR 0.152.
 */
package org.keyczar;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.EncryptedPrivateKeyInfo;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import org.json.JSONObject;
import org.keyczar.exceptions.KeyczarException;
import org.keyczar.i18n.Messages;
import org.keyczar.interfaces.KeyType;
import org.keyczar.interfaces.Stream;
import org.keyczar.util.Base64Coder;
import org.keyczar.util.Util;

public abstract class KeyczarKey {
    private static final String PEM_FOOTER_BEGIN = "-----END ";
    private static final String PEM_LINE_ENDING = "-----\n";
    private static final String PEM_HEADER_BEGIN = "-----BEGIN ";
    final int size;
    private static final int PBE_SALT_SIZE = 8;
    private static final int IV_SIZE = 16;
    private static final int PBE_ITERATION_COUNT = 1000;
    private static final String PBE_CIPHER = "PBEWithSHA1AndDESede";

    protected KeyczarKey(int size) {
        this.size = size;
    }

    void copyHeader(ByteBuffer dest) {
        dest.put((byte)0);
        dest.put(this.hash());
    }

    public boolean equals(Object o) {
        try {
            KeyczarKey key = (KeyczarKey)o;
            return Arrays.equals(key.hash(), this.hash());
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public int hashCode() {
        return Util.toInt(this.hash());
    }

    protected abstract Stream getStream() throws KeyczarException;

    public abstract KeyType getType();

    protected abstract byte[] hash();

    int size() {
        return this.size;
    }

    public static void registerType(KeyType keyType) {
        KeyType.KeyTypeDeserializer.registerType(keyType);
    }

    public String toString() {
        return this.toJson().toString();
    }

    abstract JSONObject toJson();

    public String getPemString(String passphrase) throws KeyczarException {
        if (this.isSecret()) {
            if (passphrase == null || passphrase.length() < 8) {
                throw new KeyczarException(Messages.getString("KeyczarTool.PassphraseRequired", new Object[0]));
            }
            return this.convertDerToPem(KeyczarKey.encryptPrivateKey(this.getJceKey(), passphrase));
        }
        if (passphrase != null && !"".equals(passphrase)) {
            throw new KeyczarException(Messages.getString("KeyczarTool.PassphraseNotAllowed", new Object[0]));
        }
        return this.convertDerToPem(this.getJceKey().getEncoded());
    }

    private static byte[] encryptPrivateKey(Key key, String passphrase) throws KeyczarException {
        try {
            PBEKeySpec pbeSpec = new PBEKeySpec(passphrase.toCharArray());
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(PBE_CIPHER);
            SecretKey pkcs8EncryptionKey = keyFactory.generateSecret(pbeSpec);
            byte[] salt = new byte[8];
            Util.rand(salt);
            byte[] iv = new byte[16];
            Util.rand(iv);
            Cipher cipher = Cipher.getInstance(PBE_CIPHER);
            cipher.init(1, (Key)pkcs8EncryptionKey, new PBEParameterSpec(salt, 1000));
            byte[] encryptedKey = cipher.doFinal(key.getEncoded());
            EncryptedPrivateKeyInfo inf = new EncryptedPrivateKeyInfo(cipher.getParameters(), encryptedKey);
            return inf.getEncoded();
        }
        catch (GeneralSecurityException e) {
            throw new KeyczarException(Messages.getString("KeyczarTool.FailedToEncryptPrivateKey", new Object[0]), e);
        }
        catch (IOException e) {
            throw new KeyczarException(Messages.getString("KeyczarTool.FailedToEncryptPrivateKey", new Object[0]), e);
        }
    }

    private String convertDerToPem(byte[] keyData) {
        String base64Key = Base64Coder.encodeMime(keyData, true);
        StringBuffer result = new StringBuffer();
        result.append(PEM_HEADER_BEGIN);
        result.append(this.getPemType());
        result.append(PEM_LINE_ENDING);
        for (String line : Util.split(base64Key, 64)) {
            result.append(line);
            result.append('\n');
        }
        result.append(PEM_FOOTER_BEGIN);
        result.append(this.getPemType());
        result.append(PEM_LINE_ENDING);
        return result.toString();
    }

    protected boolean isSecret() {
        return true;
    }

    protected abstract Key getJceKey();

    private String getPemType() {
        if (this.isSecret()) {
            return "ENCRYPTED PRIVATE KEY";
        }
        return this.getJceKey().getAlgorithm() + " PUBLIC KEY";
    }
}

