/*
 * Decompiled with CFR 0.152.
 */
package org.keyczar;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.keyczar.DefaultKeyType;
import org.keyczar.KeyVersion;
import org.keyczar.enums.KeyPurpose;
import org.keyczar.enums.KeyStatus;
import org.keyczar.exceptions.NoPrimaryKeyException;
import org.keyczar.interfaces.KeyType;
import org.keyczar.util.Util;

public class KeyMetadata {
    String name = "";
    KeyPurpose purpose = KeyPurpose.TEST;
    KeyType type = DefaultKeyType.TEST;
    List<KeyVersion> versions = new ArrayList<KeyVersion>();
    boolean encrypted = false;
    protected Map<Integer, KeyVersion> versionMap = new HashMap<Integer, KeyVersion>();

    public KeyMetadata(String n, KeyPurpose p, KeyType t) {
        this.name = n;
        this.purpose = p;
        this.type = t;
    }

    private KeyMetadata(String name, KeyPurpose purpose, KeyType type, List<KeyVersion> versions, boolean encrypted) {
        this.name = name;
        this.purpose = purpose;
        this.type = type;
        this.versions = versions;
        this.encrypted = encrypted;
    }

    public String toString() {
        try {
            return new JSONObject().put("name", this.name).put("purpose", this.purpose != null ? this.purpose.name() : null).put("type", this.type != null ? this.type.getName() : null).put("versions", this.keyVersionsToJson()).put("encrypted", this.encrypted).toString();
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    private JSONArray keyVersionsToJson() {
        JSONArray jsonArray = new JSONArray();
        int max = this.versions.size();
        for (int i = 0; i < max; ++i) {
            jsonArray.put(this.versions.get(i).toJson());
        }
        return jsonArray;
    }

    public boolean addVersion(KeyVersion version) {
        int versionNumber = version.getVersionNumber();
        if (!this.versionMap.containsKey(versionNumber)) {
            this.versionMap.put(versionNumber, version);
            this.versions.add(version);
            return true;
        }
        return false;
    }

    boolean removeVersion(int versionNumber) {
        if (this.versionMap.containsKey(versionNumber)) {
            KeyVersion version = this.versionMap.get(versionNumber);
            this.versions.remove(version);
            this.versionMap.remove(versionNumber);
            return true;
        }
        return false;
    }

    String getName() {
        return this.name;
    }

    KeyPurpose getPurpose() {
        return this.purpose;
    }

    KeyType getType() {
        return this.type;
    }

    void setType(KeyType type) {
        this.type = type;
    }

    void setEncrypted(boolean encrypted) {
        this.encrypted = encrypted;
    }

    boolean isEncrypted() {
        return this.encrypted;
    }

    KeyVersion getVersion(int versionNumber) {
        return this.versionMap.get(versionNumber);
    }

    List<KeyVersion> getVersions() {
        return this.versions;
    }

    public KeyVersion getPrimaryVersion() throws NoPrimaryKeyException {
        for (KeyVersion version : this.versions) {
            if (version.getStatus() != KeyStatus.PRIMARY) continue;
            return version;
        }
        throw new NoPrimaryKeyException();
    }

    public static KeyMetadata read(String jsonString) {
        try {
            JSONObject json = new JSONObject(jsonString);
            KeyMetadata kmd = new KeyMetadata(json.getString("name"), Util.deserializeEnum(KeyPurpose.class, json.optString("purpose")), new KeyType.KeyTypeDeserializer().deserialize(json.getString("type")), KeyMetadata.buildVersions(json.getJSONArray("versions")), json.getBoolean("encrypted"));
            for (KeyVersion version : kmd.getVersions()) {
                kmd.versionMap.put(version.getVersionNumber(), version);
            }
            return kmd;
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    private static List<KeyVersion> buildVersions(JSONArray jsonArray) throws JSONException {
        ArrayList<KeyVersion> list = new ArrayList<KeyVersion>();
        int max = jsonArray.length();
        for (int i = 0; i < max; ++i) {
            list.add(KeyVersion.fromJson(jsonArray.getJSONObject(i)));
        }
        return list;
    }
}

