/*
 * Decompiled with CFR 0.152.
 */
package org.keyczar;

import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.json.JSONException;
import org.json.JSONObject;
import org.keyczar.DefaultKeyType;
import org.keyczar.KeyczarKey;
import org.keyczar.exceptions.KeyczarException;
import org.keyczar.interfaces.KeyType;
import org.keyczar.interfaces.SigningStream;
import org.keyczar.interfaces.Stream;
import org.keyczar.interfaces.VerifyingStream;
import org.keyczar.keyparams.KeyParameters;
import org.keyczar.util.Base64Coder;
import org.keyczar.util.Util;

public class HmacKey
extends KeyczarKey {
    private static final String MAC_ALGORITHM = "HMACSHA1";
    private static final int HMAC_DIGEST_SIZE = 20;
    private final String hmacKeyString;
    private SecretKey hmacKey;
    private final byte[] hash = new byte[4];

    public HmacKey(byte[] keyBytes) throws KeyczarException {
        super(keyBytes.length * 8);
        this.hmacKeyString = Base64Coder.encodeWebSafe(keyBytes);
        this.initJceKey(keyBytes);
    }

    private HmacKey(int size, String hmacKeyString) {
        super(size);
        this.hmacKeyString = hmacKeyString;
    }

    static HmacKey generate(KeyParameters params) throws KeyczarException {
        return new HmacKey(Util.rand(params.getKeySize() / 8));
    }

    void initFromJson() throws KeyczarException {
        this.initJceKey(Base64Coder.decodeWebSafe(this.hmacKeyString));
    }

    private void initJceKey(byte[] keyBytes) throws KeyczarException {
        this.hmacKey = new SecretKeySpec(keyBytes, MAC_ALGORITHM);
        System.arraycopy(Util.hash(new byte[][]{keyBytes}), 0, this.hash, 0, this.hash.length);
    }

    byte[] getEncoded() {
        return this.hmacKey.getEncoded();
    }

    @Override
    protected Stream getStream() throws KeyczarException {
        return new HmacStream();
    }

    @Override
    public KeyType getType() {
        return DefaultKeyType.HMAC_SHA1;
    }

    @Override
    protected byte[] hash() {
        return this.hash;
    }

    static HmacKey read(String input) throws KeyczarException {
        try {
            HmacKey key = HmacKey.fromJson(new JSONObject(input));
            key.initFromJson();
            return key;
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    static HmacKey fromJson(JSONObject json) throws JSONException {
        return new HmacKey(json.getInt("size"), json.getString("hmacKeyString"));
    }

    @Override
    JSONObject toJson() {
        try {
            return new JSONObject().put("size", this.size).put("hmacKeyString", this.hmacKeyString);
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected SecretKey getJceKey() {
        return this.hmacKey;
    }

    private class HmacStream
    implements VerifyingStream,
    SigningStream {
        private final Mac hmac;

        public HmacStream() throws KeyczarException {
            try {
                this.hmac = Mac.getInstance(HmacKey.MAC_ALGORITHM);
            }
            catch (GeneralSecurityException e) {
                throw new KeyczarException(e);
            }
        }

        @Override
        public int digestSize() {
            return 20;
        }

        @Override
        public void initSign() throws KeyczarException {
            try {
                this.hmac.init(HmacKey.this.hmacKey);
            }
            catch (GeneralSecurityException e) {
                throw new KeyczarException(e);
            }
        }

        @Override
        public void initVerify() throws KeyczarException {
            this.initSign();
        }

        @Override
        public void sign(ByteBuffer output) {
            output.put(this.hmac.doFinal());
        }

        @Override
        public void updateSign(ByteBuffer input) {
            this.hmac.update(input);
        }

        @Override
        public void updateVerify(ByteBuffer input) {
            this.updateSign(input);
        }

        @Override
        public boolean verify(ByteBuffer signature) {
            byte[] sigBytes = new byte[signature.remaining()];
            signature.get(sigBytes);
            return Util.safeArrayEquals(this.hmac.doFinal(), sigBytes);
        }
    }
}

