/*
 * Decompiled with CFR 0.152.
 */
package org.keyczar;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import org.keyczar.DefaultKeyType;
import org.keyczar.Encrypter;
import org.keyczar.KeyMetadata;
import org.keyczar.KeyVersion;
import org.keyczar.Keyczar;
import org.keyczar.KeyczarKey;
import org.keyczar.KeyczarPrivateKey;
import org.keyczar.KeyczarPublicKey;
import org.keyczar.KeyczarTool;
import org.keyczar.enums.KeyPurpose;
import org.keyczar.enums.KeyStatus;
import org.keyczar.exceptions.KeyczarException;
import org.keyczar.i18n.Messages;
import org.keyczar.interfaces.KeyType;
import org.keyczar.interfaces.KeyczarReader;
import org.keyczar.keyparams.KeyParameters;

class GenericKeyczar
extends Keyczar {
    GenericKeyczar(KeyczarReader reader) throws KeyczarException {
        super(reader);
    }

    GenericKeyczar(String location) throws KeyczarException {
        super(location);
    }

    @Override
    boolean isAcceptablePurpose(KeyPurpose purpose) {
        return true;
    }

    KeyMetadata getMetadata() {
        return this.kmd;
    }

    Set<KeyVersion> getVersions() {
        return Collections.unmodifiableSet(this.versionMap.keySet());
    }

    KeyczarKey getKey(KeyVersion v) {
        return (KeyczarKey)this.versionMap.get(v);
    }

    void promote(int versionNumber) throws KeyczarException {
        KeyVersion version = this.getVersion(versionNumber);
        switch (version.getStatus()) {
            case PRIMARY: {
                throw new KeyczarException(Messages.getString("Keyczar.CantPromotePrimary", new Object[0]));
            }
            case ACTIVE: {
                version.setStatus(KeyStatus.PRIMARY);
                if (this.primaryVersion != null) {
                    this.primaryVersion.setStatus(KeyStatus.ACTIVE);
                }
                this.primaryVersion = version;
                break;
            }
            case INACTIVE: {
                version.setStatus(KeyStatus.ACTIVE);
            }
        }
    }

    void demote(int versionNumber) throws KeyczarException {
        KeyVersion version = this.getVersion(versionNumber);
        switch (version.getStatus()) {
            case PRIMARY: {
                version.setStatus(KeyStatus.ACTIVE);
                this.primaryVersion = null;
                break;
            }
            case ACTIVE: {
                version.setStatus(KeyStatus.INACTIVE);
                break;
            }
            case INACTIVE: {
                throw new KeyczarException(Messages.getString("Keyczar.CantDemoteScheduled", new Object[0]));
            }
        }
    }

    void addVersion(KeyStatus status) throws KeyczarException {
        this.addVersion(status, this.kmd.getType().applyDefaultParameters(null));
    }

    void addVersion(KeyStatus status, KeyParameters keyParams) throws KeyczarException {
        KeyczarKey key;
        KeyType type = this.kmd.getType();
        while (this.haveKeyWithId((key = type.getBuilder().generate(keyParams)).hash())) {
        }
        this.addVersion(status, key);
    }

    public void addVersion(KeyStatus status, KeyczarKey key) {
        KeyVersion version = new KeyVersion(this.maxVersion() + 1, status, false);
        if (status == KeyStatus.PRIMARY) {
            if (this.primaryVersion != null) {
                this.primaryVersion.setStatus(KeyStatus.ACTIVE);
            }
            this.primaryVersion = version;
        }
        this.addKey(version, key);
    }

    private int maxVersion() {
        int max = 0;
        for (KeyVersion version : this.getVersions()) {
            if (version.getVersionNumber() <= max) continue;
            max = version.getVersionNumber();
        }
        return max;
    }

    KeyVersion getVersion(int versionNumber) throws KeyczarException {
        KeyVersion version = this.kmd.getVersion(versionNumber);
        if (version == null) {
            throw new KeyczarException(Messages.getString("Keyczar.NoSuchVersion", versionNumber));
        }
        return version;
    }

    void revoke(int versionNumber) throws KeyczarException {
        KeyVersion version = this.getVersion(versionNumber);
        if (version.getStatus() != KeyStatus.INACTIVE) {
            throw new KeyczarException(Messages.getString("Keyczar.CantRevoke", new Object[0]));
        }
        this.kmd.removeVersion(versionNumber);
    }

    private boolean haveKeyWithId(byte[] keyId) {
        return this.getKey(keyId) != null;
    }

    private int numVersions() {
        return this.versionMap.size();
    }

    void publicKeyExport(String destination) throws KeyczarException {
        if (destination != null && !destination.endsWith(File.separator)) {
            destination = destination + File.separator;
        }
        KeyMetadata kmd = this.getMetadata();
        KeyMetadata publicKmd = null;
        if (kmd.getType() == DefaultKeyType.DSA_PRIV) {
            if (kmd.getPurpose() == KeyPurpose.SIGN_AND_VERIFY) {
                publicKmd = new KeyMetadata(kmd.getName(), KeyPurpose.VERIFY, DefaultKeyType.DSA_PUB);
            }
        } else if (kmd.getType() == DefaultKeyType.RSA_PRIV) {
            switch (kmd.getPurpose()) {
                case DECRYPT_AND_ENCRYPT: {
                    publicKmd = new KeyMetadata(kmd.getName(), KeyPurpose.ENCRYPT, DefaultKeyType.RSA_PUB);
                    break;
                }
                case SIGN_AND_VERIFY: {
                    publicKmd = new KeyMetadata(kmd.getName(), KeyPurpose.VERIFY, DefaultKeyType.RSA_PUB);
                }
            }
        }
        if (publicKmd == null) {
            throw new KeyczarException(Messages.getString("KeyczarTool.CannotExportPubKey", new Object[]{kmd.getType(), kmd.getPurpose()}));
        }
        for (KeyVersion version : this.getVersions()) {
            KeyczarPublicKey publicKey = ((KeyczarPrivateKey)((Object)this.getKey(version))).getPublic();
            if (KeyczarTool.getMock() == null) {
                this.writeFile(publicKey.toString(), destination + version.getVersionNumber());
            } else {
                KeyczarTool.getMock().setPublicKey(version.getVersionNumber(), publicKey);
            }
            publicKmd.addVersion(version);
        }
        if (KeyczarTool.getMock() == null) {
            this.writeFile(publicKmd.toString(), destination + "meta");
        } else {
            KeyczarTool.getMock().setPublicKeyMetadata(publicKmd);
        }
    }

    void write(String location) throws KeyczarException {
        for (KeyVersion version : this.getVersions()) {
            this.writeFile(this.getKey(version).toString(), location + version.getVersionNumber());
        }
        this.writeFile(this.kmd.toString(), location + "meta");
    }

    void writeEncrypted(String location, Encrypter encrypter) throws KeyczarException {
        KeyMetadata kmd = this.getMetadata();
        kmd.setEncrypted(true);
        for (KeyVersion version : this.getVersions()) {
            this.writeFile(encrypter.encrypt(this.getKey(version).toString()), location + version.getVersionNumber());
        }
        this.writeFile(kmd.toString(), location + "meta");
    }

    void writeFile(String data, String location) throws KeyczarException {
        File outputFile = new File(location);
        try {
            FileWriter writer = new FileWriter(outputFile);
            boolean appliesToAll = false;
            boolean appliesToOwner = true;
            outputFile.setReadable(false, false);
            outputFile.setReadable(true, true);
            outputFile.setWritable(false, false);
            outputFile.setWritable(true, true);
            outputFile.setExecutable(false, false);
            writer.write(data);
            writer.close();
        }
        catch (IOException e) {
            throw new KeyczarException(Messages.getString("KeyczarTool.UnableToWrite", outputFile.toString()), e);
        }
    }
}

