/*
 * Decompiled with CFR 0.152.
 */
package org.keyczar;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.DSAPrivateKey;
import java.security.spec.DSAPrivateKeySpec;
import org.json.JSONException;
import org.json.JSONObject;
import org.keyczar.DefaultKeyType;
import org.keyczar.DsaPublicKey;
import org.keyczar.KeyczarKey;
import org.keyczar.KeyczarPrivateKey;
import org.keyczar.KeyczarPublicKey;
import org.keyczar.exceptions.KeyczarException;
import org.keyczar.interfaces.KeyType;
import org.keyczar.interfaces.SigningStream;
import org.keyczar.interfaces.Stream;
import org.keyczar.interfaces.VerifyingStream;
import org.keyczar.keyparams.KeyParameters;
import org.keyczar.util.Base64Coder;
import org.keyczar.util.Util;

public class DsaPrivateKey
extends KeyczarKey
implements KeyczarPrivateKey {
    private static final String KEY_GEN_ALGORITHM = "DSA";
    private static final String SIG_ALGORITHM = "SHA1withDSA";
    private static final int DSA_DIGEST_SIZE = 48;
    private final DsaPublicKey publicKey;
    private final String x;
    private DSAPrivateKey jcePrivateKey;

    static DsaPrivateKey generate(KeyParameters params) throws KeyczarException {
        return new DsaPrivateKey((DSAPrivateKey)Util.generateKeyPair(KEY_GEN_ALGORITHM, params.getKeySize()).getPrivate());
    }

    static DsaPrivateKey read(String input) throws KeyczarException {
        try {
            JSONObject json = new JSONObject(input);
            DsaPrivateKey key = new DsaPrivateKey(json.getInt("size"), DsaPublicKey.fromJson(json.getJSONObject("publicKey")), json.getString("x"));
            return key.initFromJson();
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    JSONObject toJson() {
        try {
            return new JSONObject().put("size", this.size).put("publicKey", this.publicKey != null ? this.publicKey.toJson() : null).put("x", this.x);
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    public DsaPrivateKey(DSAPrivateKey privateKey) throws KeyczarException {
        super(privateKey.getParams().getP().bitLength());
        this.publicKey = new DsaPublicKey(privateKey);
        this.jcePrivateKey = privateKey;
        this.x = Base64Coder.encodeWebSafe(this.jcePrivateKey.getX().toByteArray());
    }

    private DsaPrivateKey(int size, DsaPublicKey publicKey, String x) {
        super(size);
        this.publicKey = publicKey;
        this.x = x;
    }

    @Override
    protected byte[] hash() {
        return this.getPublic().hash();
    }

    public String getKeyGenAlgorithm() {
        return KEY_GEN_ALGORITHM;
    }

    @Override
    public KeyczarPublicKey getPublic() {
        return this.publicKey;
    }

    @Override
    protected Stream getStream() throws KeyczarException {
        return new DsaSigningStream();
    }

    @Override
    public KeyType getType() {
        return DefaultKeyType.DSA_PRIV;
    }

    private DsaPrivateKey initFromJson() throws KeyczarException {
        this.publicKey.initFromJson();
        BigInteger xVal = new BigInteger(Base64Coder.decodeWebSafe(this.x));
        BigInteger pVal = new BigInteger(Base64Coder.decodeWebSafe(this.publicKey.p));
        BigInteger qVal = new BigInteger(Base64Coder.decodeWebSafe(this.publicKey.q));
        BigInteger gVal = new BigInteger(Base64Coder.decodeWebSafe(this.publicKey.g));
        try {
            KeyFactory kf = KeyFactory.getInstance(KEY_GEN_ALGORITHM);
            DSAPrivateKeySpec spec = new DSAPrivateKeySpec(xVal, pVal, qVal, gVal);
            this.jcePrivateKey = (DSAPrivateKey)kf.generatePrivate(spec);
            return this;
        }
        catch (GeneralSecurityException e) {
            throw new KeyczarException(e);
        }
    }

    @Override
    protected DSAPrivateKey getJceKey() {
        return this.jcePrivateKey;
    }

    private class DsaSigningStream
    implements SigningStream,
    VerifyingStream {
        private Signature signature;
        private VerifyingStream verifyingStream;

        public DsaSigningStream() throws KeyczarException {
            try {
                this.signature = Signature.getInstance(DsaPrivateKey.SIG_ALGORITHM);
                this.verifyingStream = (VerifyingStream)DsaPrivateKey.this.publicKey.getStream();
            }
            catch (GeneralSecurityException e) {
                throw new KeyczarException(e);
            }
        }

        @Override
        public int digestSize() {
            return 48;
        }

        @Override
        public void initSign() throws KeyczarException {
            try {
                this.signature.initSign(DsaPrivateKey.this.jcePrivateKey);
            }
            catch (GeneralSecurityException e) {
                throw new KeyczarException(e);
            }
        }

        @Override
        public void initVerify() throws KeyczarException {
            this.verifyingStream.initVerify();
        }

        @Override
        public void sign(ByteBuffer output) throws KeyczarException {
            try {
                byte[] sig = this.signature.sign();
                output.put(sig);
            }
            catch (SignatureException e) {
                throw new KeyczarException(e);
            }
        }

        @Override
        public void updateSign(ByteBuffer input) throws KeyczarException {
            try {
                this.signature.update(input);
            }
            catch (SignatureException e) {
                throw new KeyczarException(e);
            }
        }

        @Override
        public void updateVerify(ByteBuffer input) throws KeyczarException {
            this.verifyingStream.updateVerify(input);
        }

        @Override
        public boolean verify(ByteBuffer sig) throws KeyczarException {
            return this.verifyingStream.verify(sig);
        }
    }
}

