/*
 * Decompiled with CFR 0.152.
 */
package org.keyczar;

import java.util.Arrays;
import java.util.List;
import org.keyczar.AesKey;
import org.keyczar.DsaPrivateKey;
import org.keyczar.DsaPublicKey;
import org.keyczar.HmacKey;
import org.keyczar.KeyczarKey;
import org.keyczar.RsaPrivateKey;
import org.keyczar.RsaPublicKey;
import org.keyczar.enums.RsaPadding;
import org.keyczar.exceptions.KeyczarException;
import org.keyczar.exceptions.UnsupportedTypeException;
import org.keyczar.i18n.Messages;
import org.keyczar.interfaces.KeyType;
import org.keyczar.keyparams.AesKeyParameters;
import org.keyczar.keyparams.KeyParameters;
import org.keyczar.keyparams.RsaKeyParameters;

public enum DefaultKeyType implements KeyType
{
    AES(Arrays.asList(128, 192, 256)),
    HMAC_SHA1(Arrays.asList(256)),
    DSA_PRIV(Arrays.asList(1024)),
    DSA_PUB(Arrays.asList(1024)),
    RSA_PRIV(Arrays.asList(4096, 2048, 1024)),
    RSA_PUB(Arrays.asList(4096, 2048, 1024)),
    EC_PRIV(Arrays.asList(256, 384, 521, 192)),
    EC_PUB(Arrays.asList(256, 384, 521, 192)),
    TEST(Arrays.asList(1));

    private final List<Integer> acceptableSizes;

    private DefaultKeyType(List<Integer> sizes) {
        this.acceptableSizes = sizes;
    }

    @Override
    public String validateKeyParameters(KeyParameters keyParams) throws KeyczarException {
        this.validateParametersType(keyParams);
        return this.validateKeySize(keyParams);
    }

    private void validateParametersType(KeyParameters keyParams) throws KeyczarException {
        switch (this) {
            case RSA_PRIV: {
                if (keyParams instanceof RsaKeyParameters) break;
                throw new KeyczarException("Invalid key parameters type");
            }
            case AES: {
                if (keyParams instanceof AesKeyParameters) break;
                throw new KeyczarException("Invalid key parameters type");
            }
        }
    }

    private String validateKeySize(KeyParameters keyParams) throws KeyczarException {
        int keySize = keyParams.getKeySize();
        if (!this.isAcceptableSize(keySize)) {
            throw new KeyczarException("Invalid key size");
        }
        int defaultKeySize = this.acceptableSizes.get(0);
        if (keySize < defaultKeySize) {
            return Messages.getString("Keyczar.SizeWarning", keySize, defaultKeySize, this.toString());
        }
        return null;
    }

    @Override
    public KeyParameters applyDefaultParameters(KeyParameters parameters) {
        switch (this) {
            case RSA_PRIV: {
                return new DefaultingRsaKeyParameters(parameters);
            }
            case AES: {
                return new DefaultingAesKeyParameters(parameters);
            }
        }
        return new DefaultingKeyParameters(parameters);
    }

    boolean isAcceptableSize(int size) {
        return this.acceptableSizes.contains(size);
    }

    @Override
    public String getName() {
        return this.name();
    }

    @Override
    public KeyType.Builder getBuilder() {
        return new DefaultKeyBuilder();
    }

    private class DefaultKeyBuilder
    implements KeyType.Builder {
        private DefaultKeyBuilder() {
        }

        @Override
        public KeyczarKey read(String key) throws KeyczarException {
            switch (DefaultKeyType.this) {
                case AES: {
                    return AesKey.read(key);
                }
                case HMAC_SHA1: {
                    return HmacKey.read(key);
                }
                case DSA_PRIV: {
                    return DsaPrivateKey.read(key);
                }
                case DSA_PUB: {
                    return DsaPublicKey.read(key);
                }
                case RSA_PRIV: {
                    return RsaPrivateKey.read(key);
                }
                case RSA_PUB: {
                    return RsaPublicKey.read(key);
                }
            }
            throw new UnsupportedTypeException(DefaultKeyType.this);
        }

        @Override
        public KeyczarKey generate(KeyParameters params) throws KeyczarException {
            params = DefaultKeyType.this.applyDefaultParameters(params);
            DefaultKeyType.this.validateKeyParameters(params);
            switch (DefaultKeyType.this) {
                case AES: {
                    return AesKey.generate((AesKeyParameters)params);
                }
                case HMAC_SHA1: {
                    return HmacKey.generate(params);
                }
                case DSA_PRIV: {
                    return DsaPrivateKey.generate(params);
                }
                case RSA_PRIV: {
                    return RsaPrivateKey.generate((RsaKeyParameters)params);
                }
                case DSA_PUB: 
                case RSA_PUB: {
                    throw new KeyczarException(Messages.getString("KeyczarKey.PublicKeyExport", DefaultKeyType.this));
                }
            }
            throw new UnsupportedTypeException(DefaultKeyType.this);
        }
    }

    private final class DefaultingRsaKeyParameters
    extends DefaultingKeyParameters
    implements RsaKeyParameters {
        public DefaultingRsaKeyParameters(KeyParameters baseParameters) {
            super(baseParameters);
        }

        @Override
        public RsaPadding getRsaPadding() throws KeyczarException {
            RsaKeyParameters rsaBaseParameters = (RsaKeyParameters)this.baseParameters;
            if (rsaBaseParameters == null || rsaBaseParameters.getRsaPadding() == null) {
                return RsaPadding.OAEP;
            }
            return rsaBaseParameters.getRsaPadding();
        }
    }

    private class DefaultingAesKeyParameters
    extends DefaultingKeyParameters
    implements AesKeyParameters {
        public DefaultingAesKeyParameters(KeyParameters baseParameters) {
            super(baseParameters);
        }

        @Override
        public HmacKey getHmacKey() throws KeyczarException {
            return HmacKey.generate(HMAC_SHA1.applyDefaultParameters(null));
        }
    }

    private class DefaultingKeyParameters
    implements KeyParameters {
        protected final KeyParameters baseParameters;

        public DefaultingKeyParameters(KeyParameters baseParameters) {
            this.baseParameters = baseParameters;
        }

        @Override
        public int getKeySize() throws KeyczarException {
            if (this.baseParameters == null || this.baseParameters.getKeySize() == -1) {
                return (Integer)DefaultKeyType.this.acceptableSizes.get(0);
            }
            return this.baseParameters.getKeySize();
        }
    }
}

