/*
 * Decompiled with CFR 0.152.
 */
package org.keyczar.interop.operations;

import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;
import org.keyczar.Crypter;
import org.keyczar.Encrypter;
import org.keyczar.SignedSessionDecrypter;
import org.keyczar.SignedSessionEncrypter;
import org.keyczar.Signer;
import org.keyczar.Verifier;
import org.keyczar.exceptions.KeyczarException;
import org.keyczar.interop.operations.Operation;
import org.keyczar.util.Base64Coder;

public class SignedSessionOperation
extends Operation {
    public SignedSessionOperation(String keyPath, String testData) {
        super(keyPath, testData);
    }

    @Override
    public byte[] generate(String algorithm, Map<String, String> generateParams) throws KeyczarException {
        Encrypter keyEncrypter = new Encrypter(this.getReader(algorithm, generateParams.get("cryptedKeySet"), generateParams.get("pubKey")));
        Signer signer = new Signer(this.getReader(generateParams.get("signer"), generateParams.get("cryptedKeySet"), ""));
        SignedSessionEncrypter crypter = new SignedSessionEncrypter(keyEncrypter, signer);
        String sessionMaterial = crypter.newSession();
        byte[] ciphertext = crypter.encrypt(this.testData.getBytes());
        String output = new SignedSessionOutput(ciphertext, sessionMaterial).toString();
        return output.getBytes();
    }

    @Override
    public void test(Map<String, String> output, String algorithm, Map<String, String> generateParams, Map<String, String> testParams) throws KeyczarException {
        byte[] encryptedData = this.readOutput(output);
        String sessionMaterial = output.get("sessionMaterial");
        Crypter keyCrypter = new Crypter(this.getReader(algorithm, generateParams.get("cryptedKeySet"), testParams.get("pubKey")));
        Verifier verifier = new Verifier(this.getReader(generateParams.get("signer"), generateParams.get("cryptedKeySet"), ""));
        SignedSessionDecrypter sessionCrypter = new SignedSessionDecrypter(keyCrypter, verifier, sessionMaterial);
        byte[] decryptedData = sessionCrypter.decrypt(encryptedData);
        assert (new String(decryptedData).equals(this.testData));
    }

    @Override
    public String formatOutput(byte[] output) {
        return new String(output);
    }

    static class SignedSessionOutput {
        public final String output;
        public final String sessionMaterial;

        public SignedSessionOutput(byte[] output, String sessionMaterial) {
            this.output = Base64Coder.encodeWebSafe(output);
            this.sessionMaterial = sessionMaterial;
        }

        public String toString() {
            try {
                return new JSONObject().put("output", (Object)this.output).put("sessionMaterial", (Object)this.sessionMaterial).toString();
            }
            catch (JSONException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

