/*
 * Decompiled with CFR 0.152.
 */
package org.keyczar.interop.operations;

import java.io.File;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;
import org.keyczar.Crypter;
import org.keyczar.KeyczarEncryptedReader;
import org.keyczar.KeyczarFileReader;
import org.keyczar.exceptions.Base64DecodingException;
import org.keyczar.exceptions.KeyczarException;
import org.keyczar.interfaces.KeyczarReader;
import org.keyczar.interop.operations.AttachedSignOperation;
import org.keyczar.interop.operations.EncryptOperation;
import org.keyczar.interop.operations.SignOperation;
import org.keyczar.interop.operations.SignedSessionOperation;
import org.keyczar.interop.operations.UnversionedSignOperation;
import org.keyczar.util.Base64Coder;

public abstract class Operation {
    public final String keyPath;
    public final String testData;

    public static Operation getOperationByName(String name, String keyPath, String testData) throws KeyczarException {
        if (name.equals("unversioned")) {
            return new UnversionedSignOperation(keyPath, testData);
        }
        if (name.equals("signedSession")) {
            return new SignedSessionOperation(keyPath, testData);
        }
        if (name.equals("attached")) {
            return new AttachedSignOperation(keyPath, testData);
        }
        if (name.equals("sign")) {
            return new SignOperation(keyPath, testData);
        }
        if (name.equals("encrypt")) {
            return new EncryptOperation(keyPath, testData);
        }
        throw new KeyczarException("Operation does not exist");
    }

    protected Operation(String keyPath, String testData) {
        this.keyPath = keyPath;
        this.testData = testData;
    }

    public abstract byte[] generate(String var1, Map<String, String> var2) throws KeyczarException;

    public abstract void test(Map<String, String> var1, String var2, Map<String, String> var3, Map<String, String> var4) throws KeyczarException;

    public String getKeyPath(String algorithm) {
        File file1 = new File(this.keyPath);
        File file2 = new File(file1, algorithm);
        return file2.getPath();
    }

    public KeyczarReader getReader(String algorithm, String crypterAlgorithm, String pubKey) throws KeyczarException {
        String keysetName = algorithm + crypterAlgorithm;
        if (pubKey != null) {
            keysetName = keysetName + pubKey;
        }
        KeyczarReader reader = new KeyczarFileReader(this.getKeyPath(keysetName));
        if (!crypterAlgorithm.equals("")) {
            Crypter crypter = new Crypter(this.getKeyPath(crypterAlgorithm));
            reader = new KeyczarEncryptedReader(reader, crypter);
        }
        return reader;
    }

    public String formatOutput(byte[] output) {
        JSONObject json = new JSONObject();
        try {
            json.put("output", (Object)new Output((byte[])output).output);
            return json.toString();
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    public byte[] readOutput(Map<String, String> output) throws Base64DecodingException {
        return Base64Coder.decodeWebSafe(output.get("output"));
    }

    static class Output {
        public final String output;

        public Output(byte[] output) {
            this.output = Base64Coder.encodeWebSafe(output);
        }
    }
}

