/*
 * Decompiled with CFR 0.152.
 */
package org.keyczar.interop;

import org.keyczar.i18n.Messages;

public enum InteropCommand {
    CREATE("create"),
    GENERATE("generate"),
    TEST("test");

    private final String name;

    private InteropCommand(String name) {
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    public static InteropCommand getCommand(String command) {
        if (command == null) {
            throw new NullPointerException();
        }
        if (command.equalsIgnoreCase(CREATE.toString())) {
            return CREATE;
        }
        if (command.equalsIgnoreCase(GENERATE.toString())) {
            return GENERATE;
        }
        if (command.equalsIgnoreCase(TEST.toString())) {
            return TEST;
        }
        throw new IllegalArgumentException(Messages.getString("Command.UnknownCommand", command));
    }
}

