/*
 * Decompiled with CFR 0.152.
 */
package org.keyczar.interfaces;

import java.util.HashMap;
import java.util.Map;
import org.keyczar.DefaultKeyType;
import org.keyczar.KeyczarKey;
import org.keyczar.exceptions.KeyczarException;
import org.keyczar.keyparams.KeyParameters;

public interface KeyType {
    public String validateKeyParameters(KeyParameters var1) throws KeyczarException;

    public KeyParameters applyDefaultParameters(KeyParameters var1);

    public String getName();

    public Builder getBuilder();

    public static class KeyTypeDeserializer {
        private static Map<String, KeyType> typeMap = new HashMap<String, KeyType>();

        public static void registerType(KeyType keyType) {
            String name = keyType.getName();
            if (typeMap.containsKey(name)) {
                throw new IllegalArgumentException("Attempt to map two key types to the same name " + name);
            }
            typeMap.put(name, keyType);
        }

        public KeyType deserialize(String keyName) {
            if (!typeMap.containsKey(keyName)) {
                throw new IllegalArgumentException("Cannot deserialize " + keyName + " no such key has been registered.");
            }
            return typeMap.get(keyName);
        }

        static {
            for (DefaultKeyType key : DefaultKeyType.values()) {
                KeyTypeDeserializer.registerType(key);
            }
        }
    }

    public static interface Builder {
        public KeyczarKey read(String var1) throws KeyczarException;

        public KeyczarKey generate(KeyParameters var1) throws KeyczarException;
    }
}

