/*
 * Decompiled with CFR 0.152.
 */
package org.keyczar;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import org.keyczar.KeyczarKey;
import org.keyczar.StreamQueue;
import org.keyczar.Verifier;
import org.keyczar.enums.KeyPurpose;
import org.keyczar.exceptions.KeyczarException;
import org.keyczar.exceptions.NoPrimaryKeyException;
import org.keyczar.exceptions.ShortBufferException;
import org.keyczar.interfaces.KeyczarReader;
import org.keyczar.interfaces.SigningStream;
import org.keyczar.util.Base64Coder;
import org.keyczar.util.Util;

public class Signer
extends Verifier {
    static final int TIMESTAMP_SIZE = 8;
    private final StreamQueue<SigningStream> SIGN_QUEUE = new StreamQueue();

    public Signer(KeyczarReader reader) throws KeyczarException {
        super(reader);
    }

    public Signer(String fileLocation) throws KeyczarException {
        super(fileLocation);
    }

    public int digestSize() throws KeyczarException {
        KeyczarKey signingKey = this.getPrimaryKey();
        if (signingKey == null) {
            throw new NoPrimaryKeyException();
        }
        return 5 + ((SigningStream)signingKey.getStream()).digestSize();
    }

    public byte[] sign(byte[] input) throws KeyczarException {
        ByteBuffer output = ByteBuffer.allocate(this.digestSize());
        this.sign(ByteBuffer.wrap(input), output);
        output.reset();
        byte[] outputBytes = new byte[output.remaining()];
        output.get(outputBytes);
        return outputBytes;
    }

    public void sign(ByteBuffer input, ByteBuffer output) throws KeyczarException {
        this.sign(input, null, 0L, output);
    }

    void sign(ByteBuffer input, ByteBuffer hidden, long expirationTime, ByteBuffer output) throws KeyczarException {
        KeyczarKey signingKey = this.getPrimaryKey();
        if (signingKey == null) {
            throw new NoPrimaryKeyException();
        }
        SigningStream stream = (SigningStream)this.SIGN_QUEUE.poll();
        if (stream == null) {
            stream = (SigningStream)signingKey.getStream();
        }
        int spaceNeeded = this.digestSize();
        if (expirationTime > 0L) {
            spaceNeeded += 8;
        }
        if (output.capacity() < spaceNeeded) {
            throw new ShortBufferException(output.capacity(), spaceNeeded);
        }
        ByteBuffer header = ByteBuffer.allocate(5);
        signingKey.copyHeader(header);
        header.rewind();
        stream.initSign();
        output.mark();
        output.put(header);
        if (expirationTime > 0L) {
            ByteBuffer expiration = ByteBuffer.wrap(Util.fromLong(expirationTime));
            output.put(expiration);
            expiration.rewind();
            stream.updateSign(expiration);
        }
        if (hidden != null && hidden.remaining() > 0) {
            stream.updateSign(hidden);
        }
        stream.updateSign(input);
        stream.updateSign(ByteBuffer.wrap(FORMAT_BYTES));
        stream.sign(output);
        output.limit(output.position());
        this.SIGN_QUEUE.add(stream);
    }

    public String sign(String input) throws KeyczarException {
        try {
            return Base64Coder.encodeWebSafe(this.sign(input.getBytes("UTF-8")));
        }
        catch (UnsupportedEncodingException e) {
            throw new KeyczarException(e);
        }
    }

    public byte[] attachedSign(byte[] blob, byte[] hidden) throws KeyczarException {
        KeyczarKey signingKey = this.getPrimaryKey();
        if (signingKey == null) {
            throw new NoPrimaryKeyException();
        }
        SigningStream stream = (SigningStream)this.SIGN_QUEUE.poll();
        if (stream == null) {
            stream = (SigningStream)signingKey.getStream();
        }
        stream.initSign();
        byte[] hiddenPlusLength = Util.fromInt(0);
        if (hidden.length > 0) {
            hiddenPlusLength = Util.lenPrefix(hidden);
        }
        stream.updateSign(ByteBuffer.wrap(blob));
        stream.updateSign(ByteBuffer.wrap(hiddenPlusLength));
        stream.updateSign(ByteBuffer.wrap(FORMAT_BYTES));
        ByteBuffer output = ByteBuffer.allocate(stream.digestSize());
        output.mark();
        stream.sign(output);
        output.limit(output.position());
        byte[] signature = Util.cat(FORMAT_BYTES, signingKey.hash(), Util.lenPrefix(blob), output.array());
        this.SIGN_QUEUE.add(stream);
        return signature;
    }

    @Override
    boolean isAcceptablePurpose(KeyPurpose purpose) {
        return purpose == KeyPurpose.SIGN_AND_VERIFY;
    }
}

