/*
 * Decompiled with CFR 0.152.
 */
package org.keyczar;

import java.util.concurrent.atomic.AtomicReference;
import org.keyczar.AesKey;
import org.keyczar.Crypter;
import org.keyczar.DefaultKeyType;
import org.keyczar.Encrypter;
import org.keyczar.HmacKey;
import org.keyczar.ImportedKeyReader;
import org.keyczar.SessionMaterial;
import org.keyczar.Signer;
import org.keyczar.annotations.Experimental;
import org.keyczar.exceptions.KeyczarException;
import org.keyczar.keyparams.AesKeyParameters;
import org.keyczar.util.Base64Coder;
import org.keyczar.util.Util;

@Experimental
public class SignedSessionEncrypter {
    private static final int NONCE_SIZE = 16;
    private final Encrypter encrypter;
    private final Signer signer;
    private final AtomicReference<SessionMaterial> session = new AtomicReference();

    public SignedSessionEncrypter(Encrypter encrypter, Signer signer) {
        this.encrypter = encrypter;
        this.signer = signer;
    }

    public String newSession() throws KeyczarException {
        return this.newSession((AesKeyParameters)DefaultKeyType.AES.applyDefaultParameters(null));
    }

    @Deprecated
    public String newSession(final int aesKeySize) throws KeyczarException {
        AesKeyParameters params = new AesKeyParameters(){

            @Override
            public int getKeySize() {
                return aesKeySize;
            }

            @Override
            public HmacKey getHmacKey() throws KeyczarException {
                return HmacKey.generate(DefaultKeyType.HMAC_SHA1.applyDefaultParameters(null));
            }
        };
        SessionMaterial sessionMaterial = new SessionMaterial(this.buildSessionKey(params), this.buildNonce());
        this.session.set(sessionMaterial);
        return this.encrypter.encrypt(sessionMaterial.toString());
    }

    public String newSession(AesKeyParameters params) throws KeyczarException {
        SessionMaterial sessionMaterial = new SessionMaterial(this.buildSessionKey(params), this.buildNonce());
        this.session.set(sessionMaterial);
        return this.encrypter.encrypt(sessionMaterial.toString());
    }

    private AesKey buildSessionKey(AesKeyParameters params) throws KeyczarException {
        if (!DefaultKeyType.AES.isAcceptableSize(params.getKeySize())) {
            throw new KeyczarException("Unsupported key size requested for session");
        }
        return AesKey.generate(params);
    }

    private String buildNonce() {
        byte[] nonce = new byte[16];
        Util.rand(nonce);
        return Base64Coder.encodeWebSafe(nonce);
    }

    public byte[] encrypt(byte[] plainText) throws KeyczarException {
        if (null == this.session.get()) {
            throw new KeyczarException("Session not initialized.");
        }
        SessionMaterial material = this.session.get();
        ImportedKeyReader importedKeyReader = new ImportedKeyReader(material.getKey());
        Crypter symmetricCrypter = new Crypter(importedKeyReader);
        byte[] ciphertext = symmetricCrypter.encrypt(plainText);
        return this.signer.attachedSign(ciphertext, Base64Coder.decodeWebSafe(material.getNonce()));
    }
}

