/*
 * Decompiled with CFR 0.152.
 */
package org.keyczar;

import org.json.JSONException;
import org.json.JSONObject;
import org.keyczar.AesKey;
import org.keyczar.annotations.Experimental;
import org.keyczar.exceptions.KeyczarException;

@Experimental
public class SessionMaterial {
    private AesKey key = null;
    private String nonce = "";

    public SessionMaterial(AesKey key, String nonce) {
        this.key = key;
        this.nonce = nonce;
    }

    public AesKey getKey() throws KeyczarException {
        if (null == this.key) {
            throw new KeyczarException("Key has not been initialized");
        }
        return this.key;
    }

    public String getNonce() {
        return this.nonce;
    }

    public String toString() {
        try {
            return new JSONObject().put("key", this.key != null ? this.key.toJson() : null).put("nonce", (Object)this.nonce).toString();
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    public static SessionMaterial read(String sessionString) {
        try {
            JSONObject json = new JSONObject(sessionString);
            return new SessionMaterial(AesKey.fromJson(json.getJSONObject("key")), json.getString("nonce"));
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }
}

