/*
 * Decompiled with CFR 0.152.
 */
package org.keyczar;

import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.spec.RSAPrivateCrtKeySpec;
import javax.crypto.Cipher;
import javax.crypto.ShortBufferException;
import org.json.JSONException;
import org.json.JSONObject;
import org.keyczar.DefaultKeyType;
import org.keyczar.KeyczarKey;
import org.keyczar.KeyczarPrivateKey;
import org.keyczar.KeyczarPublicKey;
import org.keyczar.RsaPublicKey;
import org.keyczar.enums.RsaPadding;
import org.keyczar.exceptions.KeyczarException;
import org.keyczar.interfaces.DecryptingStream;
import org.keyczar.interfaces.EncryptingStream;
import org.keyczar.interfaces.KeyType;
import org.keyczar.interfaces.SigningStream;
import org.keyczar.interfaces.Stream;
import org.keyczar.interfaces.VerifyingStream;
import org.keyczar.keyparams.RsaKeyParameters;
import org.keyczar.util.Util;

public class RsaPrivateKey
extends KeyczarKey
implements KeyczarPrivateKey {
    private static final String KEY_GEN_ALGORITHM = "RSA";
    private final RsaPublicKey publicKey;
    private final String privateExponent;
    private final String primeP;
    private final String primeQ;
    private final String primeExponentP;
    private final String primeExponentQ;
    private final String crtCoefficient;
    private static final String SIG_ALGORITHM = "SHA1withRSA";
    private RSAPrivateCrtKey jcePrivateKey;

    static RsaPrivateKey generate(RsaKeyParameters params) throws KeyczarException {
        KeyPair keyPair = Util.generateKeyPair(KEY_GEN_ALGORITHM, params.getKeySize());
        return new RsaPrivateKey((RSAPrivateCrtKey)keyPair.getPrivate(), params.getRsaPadding() == null ? RsaPadding.OAEP : params.getRsaPadding());
    }

    static RsaPrivateKey read(String input) throws KeyczarException {
        try {
            JSONObject json = new JSONObject(input);
            return new RsaPrivateKey(json.getInt("size"), RsaPublicKey.fromJson(json.getJSONObject("publicKey")), json.getString("privateExponent"), json.getString("primeP"), json.getString("primeQ"), json.getString("primeExponentP"), json.getString("primeExponentQ"), json.getString("crtCoefficient")).initFromJson();
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    public RsaPrivateKey(RSAPrivateCrtKey privateKey, RsaPadding padding) throws KeyczarException {
        super(privateKey.getModulus().bitLength());
        this.publicKey = new RsaPublicKey(privateKey, padding);
        this.privateExponent = Util.encodeBigInteger(privateKey.getPrivateExponent());
        this.primeP = Util.encodeBigInteger(privateKey.getPrimeP());
        this.primeQ = Util.encodeBigInteger(privateKey.getPrimeQ());
        this.primeExponentP = Util.encodeBigInteger(privateKey.getPrimeExponentP());
        this.primeExponentQ = Util.encodeBigInteger(privateKey.getPrimeExponentQ());
        this.crtCoefficient = Util.encodeBigInteger(privateKey.getCrtCoefficient());
        this.jcePrivateKey = privateKey;
    }

    private RsaPrivateKey(int size, RsaPublicKey publicKey, String privateExponent, String primeP, String primeQ, String primeExponentP, String primeExponentQ, String crtCoefficient) {
        super(size);
        this.publicKey = publicKey;
        this.privateExponent = privateExponent;
        this.primeP = primeP;
        this.primeQ = primeQ;
        this.primeExponentP = primeExponentP;
        this.primeExponentQ = primeExponentQ;
        this.crtCoefficient = crtCoefficient;
        this.jcePrivateKey = null;
    }

    @Override
    JSONObject toJson() {
        try {
            return new JSONObject().put("size", this.size).put("publicKey", this.publicKey != null ? this.publicKey.toJson() : null).put("privateExponent", (Object)this.privateExponent).put("primeP", (Object)this.primeP).put("primeQ", (Object)this.primeQ).put("primeExponentP", (Object)this.primeExponentP).put("primeExponentQ", (Object)this.primeExponentQ).put("crtCoefficient", (Object)this.crtCoefficient);
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected Stream getStream() throws KeyczarException {
        return new RsaPrivateStream();
    }

    @Override
    public KeyType getType() {
        return DefaultKeyType.RSA_PRIV;
    }

    @Override
    protected byte[] hash() {
        return this.publicKey.hash();
    }

    @Override
    public KeyczarPublicKey getPublic() {
        return this.publicKey;
    }

    private RsaPrivateKey initFromJson() throws KeyczarException {
        this.publicKey.initFromJson();
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(KEY_GEN_ALGORITHM);
            RSAPrivateCrtKeySpec spec = new RSAPrivateCrtKeySpec(Util.decodeBigInteger(this.publicKey.modulus), Util.decodeBigInteger(this.publicKey.publicExponent), Util.decodeBigInteger(this.privateExponent), Util.decodeBigInteger(this.primeP), Util.decodeBigInteger(this.primeQ), Util.decodeBigInteger(this.primeExponentP), Util.decodeBigInteger(this.primeExponentQ), Util.decodeBigInteger(this.crtCoefficient));
            this.jcePrivateKey = (RSAPrivateCrtKey)keyFactory.generatePrivate(spec);
            return this;
        }
        catch (GeneralSecurityException e) {
            throw new KeyczarException(e);
        }
    }

    @Override
    protected RSAPrivateCrtKey getJceKey() {
        return this.jcePrivateKey;
    }

    private class RsaPrivateStream
    implements SigningStream,
    VerifyingStream,
    DecryptingStream,
    EncryptingStream {
        private Cipher cipher;
        private EncryptingStream encryptingStream;
        private Signature signature;
        private VerifyingStream verifyingStream;

        public RsaPrivateStream() throws KeyczarException {
            try {
                this.signature = Signature.getInstance(RsaPrivateKey.SIG_ALGORITHM);
                this.verifyingStream = (VerifyingStream)RsaPrivateKey.this.publicKey.getStream();
                this.cipher = Cipher.getInstance(RsaPrivateKey.this.publicKey.getPadding().getCryptAlgorithm());
                this.encryptingStream = (EncryptingStream)RsaPrivateKey.this.publicKey.getStream();
            }
            catch (GeneralSecurityException e) {
                throw new KeyczarException(e);
            }
        }

        @Override
        public int digestSize() {
            return RsaPrivateKey.this.publicKey.keySizeInBytes();
        }

        @Override
        public int doFinalDecrypt(ByteBuffer input, ByteBuffer output) throws KeyczarException {
            try {
                return this.cipher.doFinal(input, output);
            }
            catch (GeneralSecurityException e) {
                throw new KeyczarException(e);
            }
        }

        @Override
        public int doFinalEncrypt(ByteBuffer input, ByteBuffer output) throws KeyczarException {
            return this.encryptingStream.doFinalEncrypt(input, output);
        }

        @Override
        public SigningStream getSigningStream() throws KeyczarException {
            return this.encryptingStream.getSigningStream();
        }

        @Override
        public VerifyingStream getVerifyingStream() {
            return new VerifyingStream(){

                @Override
                public int digestSize() {
                    return 0;
                }

                @Override
                public void initVerify() {
                }

                @Override
                public void updateVerify(ByteBuffer input) {
                }

                @Override
                public boolean verify(ByteBuffer signature) {
                    return true;
                }
            };
        }

        @Override
        public void initDecrypt(ByteBuffer input) throws KeyczarException {
            try {
                this.cipher.init(2, RsaPrivateKey.this.jcePrivateKey);
            }
            catch (InvalidKeyException e) {
                throw new KeyczarException(e);
            }
        }

        @Override
        public int initEncrypt(ByteBuffer output) throws KeyczarException {
            return this.encryptingStream.initEncrypt(output);
        }

        @Override
        public void initSign() throws KeyczarException {
            try {
                this.signature.initSign(RsaPrivateKey.this.jcePrivateKey);
            }
            catch (GeneralSecurityException e) {
                throw new KeyczarException(e);
            }
        }

        @Override
        public void initVerify() throws KeyczarException {
            this.verifyingStream.initVerify();
        }

        @Override
        public int maxOutputSize(int inputLen) {
            return RsaPrivateKey.this.publicKey.keySizeInBytes();
        }

        @Override
        public void sign(ByteBuffer output) throws KeyczarException {
            try {
                byte[] sig = this.signature.sign();
                output.put(sig);
            }
            catch (SignatureException e) {
                throw new KeyczarException(e);
            }
        }

        @Override
        public int updateDecrypt(ByteBuffer input, ByteBuffer output) throws KeyczarException {
            try {
                return this.cipher.update(input, output);
            }
            catch (ShortBufferException e) {
                throw new KeyczarException(e);
            }
        }

        @Override
        public int updateEncrypt(ByteBuffer input, ByteBuffer output) throws KeyczarException {
            return this.encryptingStream.updateEncrypt(input, output);
        }

        @Override
        public void updateSign(ByteBuffer input) throws KeyczarException {
            try {
                this.signature.update(input);
            }
            catch (SignatureException e) {
                throw new KeyczarException(e);
            }
        }

        @Override
        public void updateVerify(ByteBuffer input) throws KeyczarException {
            this.verifyingStream.updateVerify(input);
        }

        @Override
        public boolean verify(ByteBuffer sig) throws KeyczarException {
            return this.verifyingStream.verify(sig);
        }
    }
}

