/*
 * Decompiled with CFR 0.152.
 */
package org.keyczar;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.Cipher;
import javax.crypto.EncryptedPrivateKeyInfo;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import org.keyczar.DefaultKeyType;
import org.keyczar.DsaPrivateKey;
import org.keyczar.KeyMetadata;
import org.keyczar.KeyVersion;
import org.keyczar.KeyczarKey;
import org.keyczar.RsaPrivateKey;
import org.keyczar.enums.KeyPurpose;
import org.keyczar.enums.KeyStatus;
import org.keyczar.enums.RsaPadding;
import org.keyczar.exceptions.KeyczarException;
import org.keyczar.i18n.Messages;
import org.keyczar.interfaces.KeyczarReader;
import org.keyczar.util.Base64Coder;
import org.keyczar.util.Util;

public class PkcsKeyReader
implements KeyczarReader {
    private static final Pattern PEM_HEADER_PATTERN = Pattern.compile("-----BEGIN ([A-Z ]+)-----");
    private static final Pattern PEM_FOOTER_PATTERN = Pattern.compile("-----END ([A-Z ]+)-----");
    private final KeyPurpose purpose;
    private final InputStream pkcs8Stream;
    private final RsaPadding rsaPadding;
    private final String passphrase;
    private KeyMetadata meta;
    private KeyczarKey key;

    public PkcsKeyReader(KeyPurpose purpose, InputStream pkcs8Stream, RsaPadding rsaPadding, String passphrase) throws KeyczarException {
        if (purpose == null) {
            throw new KeyczarException("Key purpose must not be null");
        }
        if (pkcs8Stream == null) {
            throw new KeyczarException("PKCS8 stream must not be null");
        }
        this.purpose = purpose;
        this.pkcs8Stream = pkcs8Stream;
        this.rsaPadding = rsaPadding;
        this.passphrase = passphrase;
    }

    @Override
    public String getKey(int version) throws KeyczarException {
        this.ensureKeyRead();
        return this.key.toString();
    }

    @Override
    public String getKey() throws KeyczarException {
        this.ensureKeyRead();
        return this.key.toString();
    }

    @Override
    public String getMetadata() throws KeyczarException {
        this.ensureKeyRead();
        return this.meta.toString();
    }

    private void ensureKeyRead() throws KeyczarException {
        try {
            if (this.key == null) {
                this.key = PkcsKeyReader.parseKeyStream(this.pkcs8Stream, this.passphrase, this.rsaPadding);
                this.meta = PkcsKeyReader.constructMetadata(this.key, this.purpose);
            }
        }
        catch (IOException e) {
            throw new KeyczarException("Error Reading key", e);
        }
    }

    private static KeyMetadata constructMetadata(KeyczarKey key, KeyPurpose purpose) throws KeyczarException {
        PkcsKeyReader.validatePurpose(key, purpose);
        KeyMetadata meta = new KeyMetadata("imported from PKCS8 file", purpose, key.getType());
        meta.addVersion(new KeyVersion(1, KeyStatus.PRIMARY, true));
        return meta;
    }

    private static void validatePurpose(KeyczarKey key, KeyPurpose purpose) throws KeyczarException {
        if (purpose == KeyPurpose.ENCRYPT && key.getType() == DefaultKeyType.DSA_PUB) {
            throw new KeyczarException(Messages.getString("Keyczartool.InvalidUseOfDsaKey", new Object[0]));
        }
    }

    private static KeyczarKey parseKeyStream(InputStream pkcs8Stream, String passphrase, RsaPadding padding) throws IOException, KeyczarException {
        byte[] pkcs8Data = PkcsKeyReader.convertPemToDer(Util.readStreamFully(pkcs8Stream));
        pkcs8Data = PkcsKeyReader.decryptPbeEncryptedKey(pkcs8Data, passphrase);
        PKCS8EncodedKeySpec kspec = new PKCS8EncodedKeySpec(pkcs8Data);
        try {
            return new RsaPrivateKey((RSAPrivateCrtKey)PkcsKeyReader.extractPrivateKey(kspec, "RSA"), padding);
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            try {
                DsaPrivateKey key = new DsaPrivateKey((DSAPrivateKey)PkcsKeyReader.extractPrivateKey(kspec, "DSA"));
                if (padding != null) {
                    throw new KeyczarException(Messages.getString("InvalidPadding", padding.name()));
                }
                return key;
            }
            catch (InvalidKeySpecException invalidKeySpecException2) {
                throw new KeyczarException(Messages.getString("KeyczarTool.InvalidPkcs8Stream", new Object[0]));
            }
        }
    }

    private static PrivateKey extractPrivateKey(PKCS8EncodedKeySpec kspec, String algorithm) throws KeyczarException, InvalidKeySpecException {
        try {
            return KeyFactory.getInstance(algorithm).generatePrivate(kspec);
        }
        catch (NoSuchAlgorithmException e) {
            throw new KeyczarException(e);
        }
    }

    private static byte[] decryptPbeEncryptedKey(byte[] pkcs8Data, String passphrase) throws KeyczarException {
        if (passphrase == null || passphrase.length() == 0) {
            return pkcs8Data;
        }
        try {
            EncryptedPrivateKeyInfo encryptedKeyInfo = new EncryptedPrivateKeyInfo(pkcs8Data);
            PBEParameterSpec pbeParamSpec = encryptedKeyInfo.getAlgParameters().getParameterSpec(PBEParameterSpec.class);
            String algName = encryptedKeyInfo.getAlgName();
            Cipher pbeCipher = Cipher.getInstance(algName);
            pbeCipher.init(2, (Key)PkcsKeyReader.computeDecryptionKey(passphrase, algName), pbeParamSpec);
            return pbeCipher.doFinal(encryptedKeyInfo.getEncryptedData());
        }
        catch (NullPointerException e) {
            throw new KeyczarException(Messages.getString("KeyczarTool.UnknownKeyEncryption", new Object[0]));
        }
        catch (GeneralSecurityException e) {
            throw new KeyczarException(Messages.getString("KeyczarTool.UnknownKeyEncryption", new Object[0]));
        }
        catch (IOException e) {
            throw new KeyczarException(Messages.getString("KeyczarTool.UnknownKeyEncryption", new Object[0]));
        }
    }

    private static SecretKey computeDecryptionKey(String passphrase, String pbeAlgorithmName) throws NoSuchAlgorithmException, InvalidKeySpecException {
        PBEKeySpec pbeKeySpec = new PBEKeySpec(passphrase.toCharArray());
        SecretKeyFactory pbeKeyFactory = SecretKeyFactory.getInstance(pbeAlgorithmName);
        return pbeKeyFactory.generateSecret(pbeKeySpec);
    }

    private static byte[] convertPemToDer(byte[] data) throws IOException, KeyczarException {
        BufferedReader bis = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(data)));
        String firstLine = bis.readLine();
        Matcher headerMatcher = PEM_HEADER_PATTERN.matcher(firstLine);
        if (!headerMatcher.matches()) {
            return data;
        }
        String header = headerMatcher.group(1);
        return PkcsKeyReader.decodeBase64(bis, header);
    }

    private static byte[] decodeBase64(BufferedReader inputStream, String expectedFooter) throws IOException, KeyczarException {
        String line;
        ByteArrayOutputStream tempStream = new ByteArrayOutputStream();
        while ((line = inputStream.readLine()) != null) {
            Matcher footerMatcher = PEM_FOOTER_PATTERN.matcher(line);
            if (!footerMatcher.matches()) {
                tempStream.write(Base64Coder.decodeMime(line));
                continue;
            }
            if (!footerMatcher.group(1).equals(expectedFooter)) break;
            return tempStream.toByteArray();
        }
        throw new KeyczarException(Messages.getString("KeyczarTool.InvalidPemFile", new Object[0]));
    }
}

