/*
 * Decompiled with CFR 0.152.
 */
package org.keyczar;

import org.json.JSONException;
import org.json.JSONObject;
import org.keyczar.enums.KeyStatus;
import org.keyczar.util.Util;

public class KeyVersion {
    private boolean exportable = false;
    private KeyStatus status = KeyStatus.ACTIVE;
    private int versionNumber = 0;

    KeyVersion(int v, boolean export) {
        this(v, KeyStatus.ACTIVE, export);
    }

    public KeyVersion(int v, KeyStatus s, boolean export) {
        this.versionNumber = v;
        this.status = s;
        this.exportable = export;
    }

    public String toString() {
        return this.toJson().toString();
    }

    JSONObject toJson() {
        try {
            return new JSONObject().put("versionNumber", this.versionNumber).put("status", this.status != null ? this.status.name() : null).put("exportable", this.exportable);
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof KeyVersion)) {
            return false;
        }
        KeyVersion v = (KeyVersion)o;
        return this.getVersionNumber() == v.getVersionNumber();
    }

    public int hashCode() {
        return this.versionNumber;
    }

    KeyStatus getStatus() {
        return this.status;
    }

    public int getVersionNumber() {
        return this.versionNumber;
    }

    boolean isExportable() {
        return this.exportable;
    }

    void setStatus(KeyStatus status) {
        this.status = status == null ? this.status : status;
    }

    static KeyVersion read(String jsonString) {
        try {
            return KeyVersion.fromJson(new JSONObject(jsonString));
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    static KeyVersion fromJson(JSONObject json) throws JSONException {
        return new KeyVersion(json.getInt("versionNumber"), Util.deserializeEnum(KeyStatus.class, json.optString("status")), json.getBoolean("exportable"));
    }
}

