/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.tests;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.security.KeyStore;
import java.security.Provider;
import java.security.Security;
import java.security.cert.X509Certificate;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.mozilla.jss.tests.Constants;
import sun.net.www.protocol.http.HttpURLConnection;

public class JSSE_SSLClient {
    private String sslRevision = "SSLv3";
    private String host = null;
    private int port = -1;
    private String cipherName = null;
    private String path = null;
    private String tunnelHost = null;
    private int tunnelPort = 0;
    private int debug_level = 0;
    private boolean handshakeCompleted = false;
    private String EOF = "test";
    private String keystoreLoc = "keystore.pfx";

    public void setSslRevision(String string) {
        this.sslRevision = string;
    }

    public void setHost(String string) {
        this.host = string;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public void setCipherSuite(String string) {
        this.cipherName = string;
    }

    public void setTunnelHost(String string) {
        this.tunnelHost = string;
    }

    public void setTunnelPort(int n) {
        this.tunnelPort = n;
    }

    public boolean isHandshakeCompleted() {
        return this.handshakeCompleted;
    }

    public void setHandshakeCompleted() {
        this.handshakeCompleted = true;
    }

    public void clearHandshakeCompleted() {
        this.handshakeCompleted = false;
    }

    public void setEOF(String string) {
        this.EOF = string;
    }

    public void setKeystoreLoc(String string) {
        this.keystoreLoc = string + "/" + this.keystoreLoc;
    }

    public String getKeystoreLoc() {
        return this.keystoreLoc;
    }

    public boolean isTunnel() {
        return this.tunnelHost != null && this.tunnelPort != 0;
    }

    public String validateConnection() {
        try {
            String string;
            SSLSocketFactory sSLSocketFactory = null;
            SSLSocket sSLSocket = null;
            SSLContext sSLContext = null;
            KeyManagerFactory keyManagerFactory = null;
            Object var5_6 = null;
            KeyStore keyStore = null;
            Object var7_8 = null;
            String string2 = "SunJCE";
            char[] cArray = "netscape".toCharArray();
            char[] cArray2 = "changeit".toCharArray();
            String string3 = System.getProperty("java.vendor");
            if (Constants.debug_level > 3) {
                System.out.println("DBEUG: JSSE_SSLClient.java java.vendor=" + string3);
            }
            if (string3.equals("IBM Corporation")) {
                System.setProperty("java.protocol.handler.pkgs", "com.ibm.net.ssl.www.protocol.Handler");
                Security.addProvider((Provider)Class.forName("com.ibm.jsse2.IBMJSSEProvider2").newInstance());
                string2 = "IBMJCE";
            } else {
                System.setProperty("java.protocol.handler.pkgs", "com.sun.net.ssl.internal.www.protocol");
                Security.addProvider((Provider)Class.forName("com.sun.crypto.provider.SunJCE").newInstance());
            }
            String string4 = new String("SunX509");
            keyStore = KeyStore.getInstance("PKCS12");
            if (string3.equals("IBM Corporation")) {
                string4 = new String("IbmX509");
                keyStore = KeyStore.getInstance("PKCS12", string2);
            }
            try {
                keyManagerFactory = KeyManagerFactory.getInstance(string4);
                keyStore.load(new FileInputStream(this.getKeystoreLoc()), cArray);
            }
            catch (Exception exception) {
                if (Constants.debug_level > 3) {
                    if (System.getProperty("java.vendor").equals("IBM Corporation")) {
                        System.out.println("Using IBM JDK: Cannot load keystore due to strong security encryption settings\nwith limited Jurisdiction policy files :\nhttp://www-1.ibm.com/support/docview.wss?uid=swg21169931");
                        return "success";
                    }
                    System.out.println(exception.getMessage());
                    exception.printStackTrace();
                }
                return "failure";
            }
            keyManagerFactory.init(keyStore, cArray);
            TrustManager[] trustManagerArray = new TrustManager[]{new X509TrustManager(){

                public boolean checkClientTrusted(X509Certificate[] x509CertificateArray) {
                    return true;
                }

                public boolean isServerTrusted(X509Certificate[] x509CertificateArray) {
                    return true;
                }

                public boolean isClientTrusted(X509Certificate[] x509CertificateArray) {
                    return true;
                }

                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) {
                }

                public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) {
                }
            }};
            sSLContext = SSLContext.getInstance(this.sslRevision);
            sSLContext.init(keyManagerFactory.getKeyManagers(), trustManagerArray, null);
            sSLSocketFactory = sSLContext.getSocketFactory();
            Socket socket = null;
            if (this.isTunnel()) {
                socket = new Socket(this.tunnelHost, this.tunnelPort);
                this.doTunnelHandshake(socket, this.host, this.port);
                sSLSocket = (SSLSocket)sSLSocketFactory.createSocket(socket, this.host, this.port, true);
            } else {
                sSLSocket = (SSLSocket)sSLSocketFactory.createSocket(this.host, this.port);
            }
            try {
                sSLSocket.addHandshakeCompletedListener(new HandshakeCompletedListener(){

                    public void handshakeCompleted(HandshakeCompletedEvent handshakeCompletedEvent) {
                        if (Constants.debug_level >= 3) {
                            System.out.println("SessionId " + handshakeCompletedEvent.getSession() + " Test Status : PASS");
                            System.out.flush();
                        }
                        JSSE_SSLClient.this.setHandshakeCompleted();
                    }
                });
            }
            catch (Exception exception) {
                return exception.getMessage();
            }
            String[] stringArray = new String[]{this.cipherName};
            sSLSocket.setEnabledCipherSuites(stringArray);
            sSLSocket.setSoTimeout(10000);
            sSLSocket.startHandshake();
            PrintWriter printWriter = new PrintWriter(new BufferedWriter(new OutputStreamWriter(sSLSocket.getOutputStream())));
            printWriter.println(this.EOF);
            printWriter.flush();
            if (printWriter.checkError()) {
                System.out.println("SSLSocketClient: java.io.PrintWriter error");
            }
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(sSLSocket.getInputStream()));
            while ((string = bufferedReader.readLine()) != null) {
            }
            bufferedReader.close();
            printWriter.close();
            sSLSocket.close();
        }
        catch (Exception exception) {
            if (Constants.debug_level > 3) {
                exception.printStackTrace();
            }
            this.setHandshakeCompleted();
            return exception.getMessage();
        }
        return "success";
    }

    private void doTunnelHandshake(Socket socket, String string, int n) throws IOException {
        String string2;
        byte[] byArray;
        OutputStream outputStream = socket.getOutputStream();
        String string3 = "CONNECT " + string + ":" + n + " HTTP/1.0\n" + "User-Agent: " + HttpURLConnection.userAgent + "\r\n\r\n";
        try {
            byArray = string3.getBytes("ASCII7");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray = string3.getBytes();
        }
        outputStream.write(byArray);
        outputStream.flush();
        byte[] byArray2 = new byte[200];
        int n2 = 0;
        int n3 = 0;
        boolean bl = false;
        InputStream inputStream = socket.getInputStream();
        boolean bl2 = false;
        while (n3 < 2) {
            int n4 = inputStream.read();
            if (n4 < 0) {
                throw new IOException("Unexpected EOF from proxy");
            }
            if (n4 == 10) {
                bl = true;
                ++n3;
                continue;
            }
            if (n4 == 13) continue;
            n3 = 0;
            if (bl || n2 >= byArray2.length) continue;
            byArray2[n2++] = (byte)n4;
        }
        try {
            string2 = new String(byArray2, 0, n2, "ASCII7");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            string2 = new String(byArray2, 0, n2);
        }
        if (!string2.startsWith("HTTP/1.0 200")) {
            throw new IOException("Unable to tunnel through " + this.tunnelHost + ":" + this.tunnelPort + ".  Proxy returns \"" + string2 + "\"");
        }
    }

    public void testTlsClient(String string, String string2, int n, String string3) {
        String string4 = System.getProperty("java.version");
        Object var6_6 = null;
        System.out.println("\nUsing java version " + string4 + "\n");
        System.out.println("Testing TLS Cipher list ...");
        JSSE_SSLClient jSSE_SSLClient = new JSSE_SSLClient();
        jSSE_SSLClient.setSslRevision("TLS");
        jSSE_SSLClient.setHost(string2);
        jSSE_SSLClient.setPort(n);
        jSSE_SSLClient.setKeystoreLoc(string3);
        if (string4.indexOf("1.4") == -1) {
            if (string != null) {
                try {
                    jSSE_SSLClient.setCipherSuite(string);
                    jSSE_SSLClient.setEOF(string);
                    String string5 = jSSE_SSLClient.validateConnection();
                    Thread.currentThread();
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {
                    System.out.println("JSSE_SSLCLient: Did not find any supported ciphers for JDK 1.4.x");
                }
            } else {
                try {
                    for (int i = 0; i < Constants.sslciphersarray_jdk150.length; ++i) {
                        if (!(i < 7 | i == 33)) continue;
                        jSSE_SSLClient.setCipherSuite(Constants.sslciphersarray_jdk150[i]);
                        jSSE_SSLClient.setEOF(Constants.sslciphersarray_jdk150[i]);
                        String string6 = jSSE_SSLClient.validateConnection();
                        Thread.currentThread();
                        Thread.sleep(1000L);
                    }
                }
                catch (Exception exception) {
                    System.out.println("JSSE_SSLCLient: Did not find any supported ciphers for JDK 1.5.x");
                }
            }
            System.out.println("Testing TLS Cipher list complete\n");
        }
    }

    public void testSslClient(String string, String string2, int n, String string3) {
        String string4 = System.getProperty("java.version");
        String string5 = null;
        System.out.println("Testing SSLv3 Cipher list ...");
        JSSE_SSLClient jSSE_SSLClient = new JSSE_SSLClient();
        jSSE_SSLClient.setSslRevision("SSLv3");
        jSSE_SSLClient.setHost(string2);
        jSSE_SSLClient.setPort(n);
        jSSE_SSLClient.setKeystoreLoc(string3);
        if (string4.indexOf("1.4") != -1) {
            if (string != null) {
                try {
                    jSSE_SSLClient.setCipherSuite(string);
                    jSSE_SSLClient.setEOF(string);
                    String string6 = jSSE_SSLClient.validateConnection();
                    Thread.currentThread();
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {
                    System.out.println("JSSE_SSLCLient: Did not find any supported ciphers for JDK 1.4.x");
                }
            } else {
                try {
                    for (int i = 0; i < Constants.sslciphersarray_jdk142.length; ++i) {
                        if (!(i < 7 | i == 22)) continue;
                        string5 = Constants.sslciphersarray_jdk142[i];
                        jSSE_SSLClient.setCipherSuite(string5);
                        jSSE_SSLClient.setEOF(Constants.sslciphersarray_jdk142[i]);
                        String string7 = jSSE_SSLClient.validateConnection();
                        Thread.currentThread();
                        Thread.sleep(1000L);
                    }
                }
                catch (Exception exception) {
                    System.out.println("JSSE_SSLCLient: Did not find any supported ciphers for JDK 1.4.x");
                }
            }
            jSSE_SSLClient.setEOF("null");
            String string8 = jSSE_SSLClient.validateConnection();
        } else {
            if (string != null) {
                try {
                    jSSE_SSLClient.setCipherSuite(string);
                    jSSE_SSLClient.setEOF(string);
                    String string9 = jSSE_SSLClient.validateConnection();
                }
                catch (Exception exception) {
                    System.out.println("JSSE_SSLCLient: Did not find any supported ciphers for JDK 1.5.x");
                }
            } else {
                try {
                    for (int i = 0; i < Constants.sslciphersarray_jdk150.length; ++i) {
                        if (!(i < 7 | i == 34)) continue;
                        string5 = Constants.sslciphersarray_jdk150[i];
                        jSSE_SSLClient.setCipherSuite(Constants.sslciphersarray_jdk150[i]);
                        jSSE_SSLClient.setEOF(Constants.sslciphersarray_jdk150[i]);
                        String string10 = jSSE_SSLClient.validateConnection();
                    }
                }
                catch (Exception exception) {
                    System.out.println("JSSE_SSLCLient: Did not find any supported ciphers for JDK 1.5.x");
                }
            }
            jSSE_SSLClient.setEOF("null");
            String string11 = jSSE_SSLClient.validateConnection();
        }
        System.out.println("Testing SSLv3 Cipher list complete\n");
    }

    public static void main(String[] stringArray) {
        String string = null;
        String string2 = "localhost";
        String string3 = "keystore.pfx";
        int n = 29750;
        String string4 = "java org.mozilla.jss.tests.JSSE_SSLClient\n<keystore location> <test port> <test cipher> <test host> ";
        try {
            if (stringArray[0].toLowerCase().equals("-h") || stringArray.length < 1) {
                System.out.println(string4);
                System.exit(1);
            }
            if (stringArray.length >= 1) {
                string3 = stringArray[0];
            }
            if (stringArray.length >= 2) {
                n = new Integer(stringArray[1]);
                System.out.println("using port: " + n);
            }
            if (stringArray.length >= 3) {
                string = stringArray[2];
            }
            if (stringArray.length == 4) {
                string2 = stringArray[3];
            }
        }
        catch (Exception exception) {
            System.out.println(string4);
            System.exit(1);
        }
        JSSE_SSLClient jSSE_SSLClient = new JSSE_SSLClient();
        try {
            Thread.currentThread();
            Thread.sleep(1000L);
            jSSE_SSLClient.testTlsClient(string, string2, n, string3);
        }
        catch (Exception exception) {
            System.out.println("Exception caught testing TLS ciphers\n" + exception.getMessage());
            exception.printStackTrace();
            System.exit(1);
        }
        try {
            Thread.currentThread();
            Thread.sleep(1000L);
            jSSE_SSLClient.testSslClient(string, string2, n, string3);
        }
        catch (Exception exception) {
            System.out.println("Exception caught testing SSLv3 ciphers\n" + exception.getMessage());
            exception.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }

    private class readThread
    extends Thread {
        private BufferedReader bir;

        public readThread(BufferedReader bufferedReader) {
            this.bir = bufferedReader;
        }

        public void run() {
            try {
                while (true) {
                    System.out.println("Client reading=======================");
                    String string = this.bir.readLine();
                    System.out.println("Client Read==" + string);
                    readThread.sleep(5L);
                }
            }
            catch (EOFException eOFException) {
                System.out.println("ReadThread got EOF");
                eOFException.printStackTrace();
                System.exit(1);
            }
            catch (IOException iOException) {
                System.out.println("ReadThread IO exception caught : " + iOException.getMessage());
                iOException.printStackTrace();
                System.exit(1);
            }
            catch (NullPointerException nullPointerException) {
                System.out.println("ReadThread Null pointer exception caught");
                nullPointerException.printStackTrace();
                System.exit(1);
            }
            catch (InterruptedException interruptedException) {
                System.out.println("ReadThread interrupted");
                interruptedException.printStackTrace();
                System.exit(1);
            }
            catch (Exception exception) {
                System.out.println("ReadThread interrupted: " + exception.getMessage());
                exception.printStackTrace();
                System.exit(1);
            }
        }
    }

    private class writeThread
    extends Thread {
        private PrintWriter w;

        public writeThread(PrintWriter printWriter) {
            this.w = printWriter;
        }

        public void run() {
            try {
                while (true) {
                    this.w.println("Client saying hi ");
                    this.w.flush();
                    writeThread.sleep(5L);
                }
            }
            catch (Exception exception) {
                System.out.println("WriteThread interrupted: " + exception.getMessage());
                System.exit(1);
                return;
            }
        }
    }
}

