/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.tests;

import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.util.Calendar;
import java.util.Date;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.asn1.BOOLEAN;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.asn1.OCTET_STRING;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.InternalCertificate;
import org.mozilla.jss.crypto.SignatureAlgorithm;
import org.mozilla.jss.crypto.X509Certificate;
import org.mozilla.jss.pkix.cert.Certificate;
import org.mozilla.jss.pkix.cert.CertificateInfo;
import org.mozilla.jss.pkix.cert.Extension;
import org.mozilla.jss.pkix.primitive.AlgorithmIdentifier;
import org.mozilla.jss.pkix.primitive.Name;
import org.mozilla.jss.pkix.primitive.SubjectPublicKeyInfo;
import org.mozilla.jss.tests.FilePasswordCallback;

public class GenerateTestCert {
    private final SignatureAlgorithm sigAlg = SignatureAlgorithm.RSASignatureWithSHA1Digest;
    private X509Certificate nssServerCert;
    private X509Certificate nssClientCert;
    private static final String CACERT_NICKNAME = "JSSCATestCert";
    private static final String SERVERCERT_NICKNAME = "JSSTestServerCert";
    private static final String CLIENTCERT_NICKNAME = "JSSTestClientCert";

    public static void main(String[] stringArray) throws Exception {
        GenerateTestCert generateTestCert = new GenerateTestCert();
        if (stringArray.length > 0) {
            generateTestCert.doIt(stringArray);
        } else {
            generateTestCert.usage();
        }
    }

    public void usage() {
        System.out.println("USAGE: java org.mozilla.jss.tests.GenerateTestCert <test dir> <password file> [hostname] [CAcertNickname] [ServerCertNickname] [ClientCertNickName]");
        System.out.println("This program creates self signed Certificates.They are only meant for testing and should never be used in production. \nThe default nicknames:\n\tCA certificate: JSSCATestCert\n\tServer certificate: JSSTestServerCert\n\tClient certificate: JSSTestClientCert");
        System.exit(1);
    }

    private void doIt(String[] stringArray) throws Exception {
        String string = CACERT_NICKNAME;
        String string2 = SERVERCERT_NICKNAME;
        String string3 = CLIENTCERT_NICKNAME;
        if (stringArray.length < 2) {
            this.usage();
        }
        try {
            X509Certificate[] x509CertificateArray;
            CryptoManager.initialize(stringArray[0]);
            CryptoManager cryptoManager = CryptoManager.getInstance();
            CryptoToken cryptoToken = cryptoManager.getInternalKeyStorageToken();
            FilePasswordCallback filePasswordCallback = new FilePasswordCallback(stringArray[1]);
            cryptoToken.login(filePasswordCallback);
            SecureRandom secureRandom = SecureRandom.getInstance("pkcs11prng", "Mozilla-JSS");
            int n = GenerateTestCert.nextRandInt(secureRandom);
            String string4 = "localhost";
            if (stringArray.length > 3) {
                string4 = stringArray[2];
            }
            if (stringArray.length > 4) {
                string = stringArray[3];
            }
            if ((x509CertificateArray = cryptoManager.findCertsByNickname(string)).length > 0) {
                System.out.println(string + " already exists!");
                System.exit(1);
            }
            if (stringArray.length > 5) {
                string2 = stringArray[4];
            }
            if ((x509CertificateArray = cryptoManager.findCertsByNickname(string2)).length > 0) {
                System.out.println(string2 + " already exists!");
                System.exit(1);
            }
            if (stringArray.length == 6) {
                string3 = stringArray[5];
            }
            if ((x509CertificateArray = cryptoManager.findCertsByNickname(string3)).length > 0) {
                System.out.println(string3 + " already exists!");
                System.exit(1);
            }
            int n2 = 512;
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA", "Mozilla-JSS");
            keyPairGenerator.initialize(n2);
            KeyPair keyPair = keyPairGenerator.genKeyPair();
            SEQUENCE sEQUENCE = new SEQUENCE();
            sEQUENCE.addElement(this.makeBasicConstraintsExtension());
            Certificate certificate = this.makeCert("CACert", "CACert", n + 1, keyPair.getPrivate(), keyPair.getPublic(), n, sEQUENCE);
            X509Certificate x509Certificate = cryptoManager.importUserCACertPackage(ASN1Util.encode(certificate), string);
            InternalCertificate internalCertificate = (InternalCertificate)x509Certificate;
            internalCertificate.setSSLTrust(152);
            keyPairGenerator.initialize(n2);
            KeyPair keyPair2 = keyPairGenerator.genKeyPair();
            Certificate certificate2 = this.makeCert("CACert", string4, n + 2, keyPair.getPrivate(), keyPair2.getPublic(), n, null);
            this.nssServerCert = cryptoManager.importCertPackage(ASN1Util.encode(certificate2), string2);
            keyPairGenerator.initialize(n2);
            KeyPair keyPair3 = keyPairGenerator.genKeyPair();
            Certificate certificate3 = this.makeCert("CACert", "ClientCert", n + 3, keyPair.getPrivate(), keyPair3.getPublic(), n, null);
            this.nssClientCert = cryptoManager.importCertPackage(ASN1Util.encode(certificate3), string3);
            System.out.println("\nThis program created certificates with \nfollowing cert nicknames:\n\t" + string + "\n\t" + string2 + "\n\t" + string3);
            System.out.println("Exiting main()");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }

    static int nextRandInt(SecureRandom secureRandom) throws Exception {
        byte[] byArray = new byte[4];
        secureRandom.nextBytes(byArray);
        int n = byArray[0] << 24 | byArray[1] << 16 | byArray[2] << 8 | byArray[3];
        System.out.println("generated random value:" + n);
        return n;
    }

    private Extension makeBasicConstraintsExtension() throws Exception {
        SEQUENCE sEQUENCE = new SEQUENCE();
        sEQUENCE.addElement(new BOOLEAN(true));
        OBJECT_IDENTIFIER oBJECT_IDENTIFIER = new OBJECT_IDENTIFIER(new long[]{2L, 5L, 29L, 19L});
        OCTET_STRING oCTET_STRING = new OCTET_STRING(ASN1Util.encode(sEQUENCE));
        return new Extension(oBJECT_IDENTIFIER, true, oCTET_STRING);
    }

    private Certificate makeCert(String string, String string2, int n, PrivateKey privateKey, PublicKey publicKey, int n2, SEQUENCE sEQUENCE) throws Exception {
        AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(this.sigAlg.toOID());
        Name name = new Name();
        name.addCommonName(string);
        name.addCountryName("US");
        name.addOrganizationName("Mozilla" + n2);
        name.addOrganizationalUnitName("JSS Testing");
        Name name2 = new Name();
        name2.addCommonName(string2);
        name2.addCountryName("US");
        name2.addOrganizationName("Mozilla" + n2);
        name2.addOrganizationalUnitName("JSS Testing");
        Calendar calendar = Calendar.getInstance();
        Date date = calendar.getTime();
        calendar.add(1, 1);
        Date date2 = calendar.getTime();
        SubjectPublicKeyInfo.Template template = new SubjectPublicKeyInfo.Template();
        SubjectPublicKeyInfo subjectPublicKeyInfo = (SubjectPublicKeyInfo)ASN1Util.decode(template, publicKey.getEncoded());
        CertificateInfo certificateInfo = new CertificateInfo(CertificateInfo.v3, new INTEGER(n), algorithmIdentifier, name, date, date2, name2, subjectPublicKeyInfo);
        if (sEQUENCE != null) {
            certificateInfo.setExtensions(sEQUENCE);
        }
        return new Certificate(certificateInfo, privateKey, this.sigAlg);
    }
}

