/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkix.primitive;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.CharConversionException;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.asn1.PrintableString;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.pkix.primitive.AVA;
import org.mozilla.jss.pkix.primitive.DirectoryString;
import org.mozilla.jss.pkix.primitive.RDN;

public class Name
implements ASN1Value {
    SEQUENCE rdns;
    public static final Tag TAG = SEQUENCE.TAG;
    public static final OBJECT_IDENTIFIER commonName = new OBJECT_IDENTIFIER(new long[]{2L, 5L, 4L, 3L});
    public static final OBJECT_IDENTIFIER countryName = new OBJECT_IDENTIFIER(new long[]{2L, 5L, 4L, 6L});
    public static final OBJECT_IDENTIFIER localityName = new OBJECT_IDENTIFIER(new long[]{2L, 5L, 4L, 7L});
    public static final OBJECT_IDENTIFIER stateOrProvinceName = new OBJECT_IDENTIFIER(new long[]{2L, 5L, 4L, 8L});
    public static final OBJECT_IDENTIFIER organizationName = new OBJECT_IDENTIFIER(new long[]{2L, 5L, 4L, 10L});
    public static final OBJECT_IDENTIFIER organizationalUnitName = new OBJECT_IDENTIFIER(new long[]{2L, 5L, 4L, 11L});
    private static final Template templateInstance = new Template();

    public Name() {
        this.rdns = new SEQUENCE();
    }

    Name(SEQUENCE sEQUENCE) {
        this.rdns = sEQUENCE;
    }

    public void addElement(RDN rDN) {
        this.rdns.addElement(rDN);
    }

    public void addElement(AVA aVA) {
        this.rdns.addElement(new RDN(aVA));
    }

    public void insertElementAt(RDN rDN, int n) {
        this.rdns.insertElementAt(rDN, n);
    }

    public RDN elementAt(int n) {
        return (RDN)this.rdns.elementAt(n);
    }

    public void removeElementAt(int n) {
        this.rdns.removeElementAt(n);
    }

    public int size() {
        return this.rdns.size();
    }

    public Tag getTag() {
        return TAG;
    }

    public void encode(OutputStream outputStream) throws IOException {
        this.rdns.encode(outputStream);
    }

    public void encode(Tag tag, OutputStream outputStream) throws IOException {
        this.rdns.encode(tag, outputStream);
    }

    public void addCommonName(String string) throws CharConversionException {
        this.addElement(new AVA(commonName, new DirectoryString(string)));
    }

    public void addCountryName(String string) throws CharConversionException {
        if (string.length() != 2) {
            throw new IllegalArgumentException("Country name must be exactly 2 characters");
        }
        this.addElement(new AVA(countryName, new DirectoryString(string)));
    }

    public void addLocalityName(String string) throws CharConversionException {
        this.addElement(new AVA(localityName, new DirectoryString(string)));
    }

    public void addStateOrProvinceName(String string) throws CharConversionException {
        this.addElement(new AVA(stateOrProvinceName, new DirectoryString(string)));
    }

    public void addOrganizationName(String string) throws CharConversionException {
        this.addElement(new AVA(organizationName, new DirectoryString(string)));
    }

    public void addOrganizationalUnitName(String string) throws CharConversionException {
        this.addElement(new AVA(organizationalUnitName, new DirectoryString(string)));
    }

    private String typeToString(OBJECT_IDENTIFIER oBJECT_IDENTIFIER) {
        if (oBJECT_IDENTIFIER.equals(commonName)) {
            return "CN";
        }
        if (oBJECT_IDENTIFIER.equals(countryName)) {
            return "C";
        }
        if (oBJECT_IDENTIFIER.equals(localityName)) {
            return "L";
        }
        if (oBJECT_IDENTIFIER.equals(stateOrProvinceName)) {
            return "S";
        }
        if (oBJECT_IDENTIFIER.equals(organizationName)) {
            return "O";
        }
        if (oBJECT_IDENTIFIER.equals(organizationalUnitName)) {
            return "OU";
        }
        return null;
    }

    private String AVAToString(AVA aVA) throws InvalidBERException {
        OBJECT_IDENTIFIER oBJECT_IDENTIFIER = aVA.getOID();
        String string = this.typeToString(oBJECT_IDENTIFIER);
        if (string == null) {
            return "";
        }
        return string + "=" + (DirectoryString)aVA.getValue().decodeWith(DirectoryString.getTemplate());
    }

    public String getRFC1485() throws InvalidBERException {
        StringBuffer stringBuffer = new StringBuffer(80);
        for (int i = 0; i < this.rdns.size(); ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.AVAToString(((RDN)this.rdns.elementAt(i)).at(0)));
        }
        return stringBuffer.toString();
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public static void main(String[] stringArray) {
        try {
            if (stringArray.length == 0) {
                Name name = new Name();
                OBJECT_IDENTIFIER oBJECT_IDENTIFIER = new OBJECT_IDENTIFIER(new long[]{2L, 5L, 4L, 10L});
                AVA aVA = new AVA(oBJECT_IDENTIFIER, new PrintableString("Netscape"));
                name.addElement(aVA);
                oBJECT_IDENTIFIER = new OBJECT_IDENTIFIER(new long[]{2L, 5L, 4L, 3L});
                aVA = new AVA(oBJECT_IDENTIFIER, new PrintableString("moi"));
                name.addElement(aVA);
                name.encode(System.out);
            } else {
                BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(stringArray[0]));
                Template template = new Template();
                Name name = (Name)template.decode(bufferedInputStream);
                System.out.println("Got name.");
                for (int i = 0; i < name.size(); ++i) {
                    AVA aVA = name.elementAt(i).at(0);
                    PrintableString.Template template2 = new PrintableString.Template();
                    PrintableString printableString = (PrintableString)template2.decode(new ByteArrayInputStream(aVA.getValue().getEncoded()));
                    System.out.println("OID: " + aVA.getOID() + ", String: " + printableString);
                }
                System.out.println("End of name");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static class Template
    implements ASN1Template {
        public boolean tagMatch(Tag tag) {
            return TAG.equals(tag);
        }

        public ASN1Value decode(InputStream inputStream) throws IOException, InvalidBERException {
            return this.decode(TAG, inputStream);
        }

        public ASN1Value decode(Tag tag, InputStream inputStream) throws IOException, InvalidBERException {
            SEQUENCE.OF_Template oF_Template = new SEQUENCE.OF_Template(new RDN.Template());
            SEQUENCE sEQUENCE = (SEQUENCE)oF_Template.decode(tag, inputStream);
            return new Name(sEQUENCE);
        }
    }
}

