/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.asn1;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.BitSet;
import org.mozilla.jss.asn1.ASN1Header;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.Form;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.util.Assert;

public class BIT_STRING
implements ASN1Value {
    private byte[] bits;
    private int padCount;
    private boolean removeTrailingZeroes = false;
    public static final Tag TAG = new Tag(Tag.UNIVERSAL, 3L);
    public static final Form FORM = Form.PRIMITIVE;
    private static final Template templateInstance = new Template();

    private BIT_STRING() {
    }

    public BIT_STRING(byte[] byArray, int n) throws NumberFormatException {
        if (n < 0 || n > 7) {
            throw new NumberFormatException();
        }
        if (byArray.length == 0 && n != 0) {
            throw new NumberFormatException();
        }
        this.bits = byArray;
        this.padCount = n;
    }

    public BIT_STRING(BitSet bitSet, int n) throws NumberFormatException {
        if (n < 0 || n > bitSet.size()) {
            throw new NumberFormatException();
        }
        this.bits = new byte[(n + 7) / 8];
        this.padCount = this.bits.length * 8 - n;
        Assert._assert(this.padCount >= 0 && this.padCount <= 7);
        for (int i = 0; i < n; ++i) {
            if (!bitSet.get(i)) continue;
            int n2 = i / 8;
            this.bits[n2] = (byte)(this.bits[n2] | 128 >>> i % 8);
        }
    }

    public boolean getRemoveTrailingZeroes() {
        return this.removeTrailingZeroes;
    }

    public void setRemoveTrailingZeroes(boolean bl) {
        this.removeTrailingZeroes = bl;
    }

    public byte[] getBits() {
        return this.bits;
    }

    public BitSet toBitSet() {
        BitSet bitSet = new BitSet();
        int n = this.bits.length * 8 - this.padCount;
        for (int i = 0; i < n; ++i) {
            if ((this.bits[i / 8] & 128 >>> i % 8) != 0) {
                bitSet.set(i);
                continue;
            }
            bitSet.clear(i);
        }
        return bitSet;
    }

    public boolean[] toBooleanArray() {
        boolean[] blArray = new boolean[this.bits.length * 8 - this.padCount];
        for (int i = 0; i < blArray.length; ++i) {
            if ((this.bits[i / 8] & 128 >>> i % 8) == 0) continue;
            blArray[i] = true;
        }
        return blArray;
    }

    public int getPadCount() {
        return this.padCount;
    }

    public Tag getTag() {
        return TAG;
    }

    public void encode(OutputStream outputStream) throws IOException {
        this.encode(TAG, outputStream);
    }

    public void encode(Tag tag, OutputStream outputStream) throws IOException {
        int n;
        int n2;
        if (this.bits.length > 0) {
            int n3 = this.bits.length - 1;
            this.bits[n3] = (byte)(this.bits[n3] & 255 << this.padCount);
        }
        if (this.removeTrailingZeroes) {
            for (n2 = this.bits.length; n2 > 0 && this.bits[n2 - 1] == 0; --n2) {
            }
            if (n2 == 0) {
                n = 0;
            } else {
                for (n = 0; n < 8 && (this.bits[n2 - 1] & 1 << n) == 0; ++n) {
                }
                Assert._assert(n >= 0 && n <= 7);
            }
        } else {
            n = this.padCount;
            n2 = this.bits.length;
        }
        ASN1Header aSN1Header = new ASN1Header(tag, FORM, n2 + 1);
        aSN1Header.encode(outputStream);
        outputStream.write(n);
        outputStream.write(this.bits, 0, n2);
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public static class Template
    implements ASN1Template {
        public boolean tagMatch(Tag tag) {
            return TAG.equals(tag);
        }

        public ASN1Value decode(InputStream inputStream) throws IOException, InvalidBERException {
            return this.decode(TAG, inputStream);
        }

        public ASN1Value decode(Tag tag, InputStream inputStream) throws IOException, InvalidBERException {
            try {
                ASN1Header aSN1Header = new ASN1Header(inputStream);
                aSN1Header.validate(tag);
                if (aSN1Header.getContentLength() == -1L) {
                    ASN1Header aSN1Header2;
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    int n = 0;
                    do {
                        if ((aSN1Header2 = ASN1Header.lookAhead(inputStream)).isEOC()) continue;
                        if (n != 0) {
                            throw new InvalidBERException("Element of constructed BIT STRING has nonzero unused bits, but is not\nthe last element of the construction.");
                        }
                        Template template = new Template();
                        BIT_STRING bIT_STRING = (BIT_STRING)template.decode(inputStream);
                        byteArrayOutputStream.write(bIT_STRING.getBits());
                        n = bIT_STRING.getPadCount();
                    } while (!aSN1Header2.isEOC());
                    aSN1Header2 = new ASN1Header(inputStream);
                    return new BIT_STRING(byteArrayOutputStream.toByteArray(), n);
                }
                int n = inputStream.read();
                if (n == -1) {
                    throw new InvalidBERException.EOF();
                }
                if (n < 0 || n > 7) {
                    throw new InvalidBERException("Unused bits not in range [0,7]");
                }
                byte[] byArray = new byte[(int)aSN1Header.getContentLength() - 1];
                ASN1Util.readFully(byArray, inputStream);
                return new BIT_STRING(byArray, n);
            }
            catch (InvalidBERException invalidBERException) {
                throw new InvalidBERException(invalidBERException, "BIT STRING");
            }
        }
    }
}

