/*
 * Decompiled with CFR 0.152.
 */
package org.keyczar.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.keyczar.exceptions.KeyczarException;

public class Util {
    private static final ConcurrentLinkedQueue<MessageDigest> DIGEST_QUEUE = new ConcurrentLinkedQueue();
    private static final ConcurrentLinkedQueue<SecureRandom> RAND_QUEUE = new ConcurrentLinkedQueue();
    private static final Gson GSON = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().create();

    private Util() {
    }

    public static Gson gson() {
        return GSON;
    }

    public static byte[] stripLeadingZeros(byte[] input) {
        int zeros = 0;
        while (zeros < input.length && input[zeros] == 0) {
            ++zeros;
        }
        if (zeros == 0) {
            return input;
        }
        byte[] output = new byte[input.length - zeros];
        System.arraycopy(input, zeros, output, 0, output.length);
        return output;
    }

    public static byte[] fromInt(int input) {
        byte[] output = new byte[4];
        Util.writeInt(input, output, 0);
        return output;
    }

    public static byte[] fromLong(long input) {
        byte[] output = new byte[8];
        Util.writeLong(input, output, 0);
        return output;
    }

    public static byte[] prefixHash(byte[] ... inputs) throws KeyczarException {
        MessageDigest md = DIGEST_QUEUE.poll();
        if (md == null) {
            try {
                md = MessageDigest.getInstance("SHA-1");
            }
            catch (NoSuchAlgorithmException e) {
                throw new KeyczarException(e);
            }
        }
        byte[][] byArray = inputs;
        int n = inputs.length;
        int n2 = 0;
        while (n2 < n) {
            byte[] array = byArray[n2];
            md.update(Util.fromInt(array.length));
            md.update(array);
            ++n2;
        }
        byte[] digest = md.digest();
        DIGEST_QUEUE.add(md);
        return digest;
    }

    public static byte[] lenPrefixPack(byte[] ... inputArrays) {
        int outputSize = (1 + inputArrays.length) * 4;
        byte[][] byArray = inputArrays;
        int n = inputArrays.length;
        int n2 = 0;
        while (n2 < n) {
            byte[] array = byArray[n2];
            outputSize += array.length;
            ++n2;
        }
        byte[] output = new byte[outputSize];
        ByteBuffer outputBuffer = ByteBuffer.wrap(output);
        outputBuffer.putInt(inputArrays.length);
        byte[][] byArray2 = inputArrays;
        int n3 = inputArrays.length;
        int n4 = 0;
        while (n4 < n3) {
            byte[] array = byArray2[n4];
            outputBuffer.putInt(array.length);
            outputBuffer.put(array);
            ++n4;
        }
        return output;
    }

    public static byte[][] lenPrefixUnpack(byte[] packedInput) {
        ByteBuffer input = ByteBuffer.wrap(packedInput);
        int numArrays = input.getInt();
        byte[][] output = new byte[numArrays][];
        int i = 0;
        while (i < numArrays) {
            int len = input.getInt();
            byte[] array = new byte[len];
            input.get(array);
            output[i] = array;
            ++i;
        }
        return output;
    }

    public static byte[] hash(byte[] ... inputs) throws KeyczarException {
        MessageDigest md = DIGEST_QUEUE.poll();
        if (md == null) {
            try {
                md = MessageDigest.getInstance("SHA-1");
            }
            catch (NoSuchAlgorithmException e) {
                throw new KeyczarException(e);
            }
        }
        byte[][] byArray = inputs;
        int n = inputs.length;
        int n2 = 0;
        while (n2 < n) {
            byte[] array = byArray[n2];
            md.update(array);
            ++n2;
        }
        byte[] digest = md.digest();
        DIGEST_QUEUE.add(md);
        return digest;
    }

    public static void rand(byte[] dest) {
        SecureRandom random = RAND_QUEUE.poll();
        if (random == null) {
            random = new SecureRandom();
        }
        random.nextBytes(dest);
        RAND_QUEUE.add(random);
    }

    public static byte[] rand(int len) {
        byte[] output = new byte[len];
        Util.rand(output);
        return output;
    }

    static int readInt(byte[] src, int offset) {
        int output = 0;
        output |= (src[offset++] & 0xFF) << 24;
        output |= (src[offset++] & 0xFF) << 16;
        output |= (src[offset++] & 0xFF) << 8;
        return output |= src[offset++] & 0xFF;
    }

    static long readLong(byte[] src, int offset) {
        long output = 0L;
        output |= ((long)src[offset++] & 0xFFL) << 56;
        output |= ((long)src[offset++] & 0xFFL) << 48;
        output |= ((long)src[offset++] & 0xFFL) << 40;
        output |= ((long)src[offset++] & 0xFFL) << 32;
        output |= ((long)src[offset++] & 0xFFL) << 24;
        output |= ((long)src[offset++] & 0xFFL) << 16;
        output |= ((long)src[offset++] & 0xFFL) << 8;
        return output |= (long)src[offset++] & 0xFFL;
    }

    public static int toInt(byte[] src) {
        return Util.readInt(src, 0);
    }

    public static long toLong(byte[] src) {
        return Util.readLong(src, 0);
    }

    static void writeInt(int input, byte[] dest, int offset) {
        dest[offset++] = (byte)(input >> 24);
        dest[offset++] = (byte)(input >> 16);
        dest[offset++] = (byte)(input >> 8);
        dest[offset++] = (byte)input;
    }

    static void writeLong(long input, byte[] dest, int offset) {
        dest[offset++] = (byte)(input >> 56);
        dest[offset++] = (byte)(input >> 48);
        dest[offset++] = (byte)(input >> 40);
        dest[offset++] = (byte)(input >> 32);
        dest[offset++] = (byte)(input >> 24);
        dest[offset++] = (byte)(input >> 16);
        dest[offset++] = (byte)(input >> 8);
        dest[offset++] = (byte)input;
    }

    public static boolean safeArrayEquals(byte[] a1, byte[] a2) {
        if (a1 == null || a2 == null) {
            return a1 == a2;
        }
        if (a1.length != a2.length) {
            return false;
        }
        int result = 0;
        int i = 0;
        while (i < a1.length) {
            result = (byte)(result | a1[i] ^ a2[i]);
            ++i;
        }
        return result == 0;
    }
}

