/*
 * Decompiled with CFR 0.152.
 */
package org.keyczar.enums;

import com.google.gson.annotations.Expose;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum KeyType {
    AES("AES", 0, Arrays.asList(128, 192, 256), 0),
    HMAC_SHA1("HMAC-SHA1", 1, Arrays.asList(256), 20),
    DSA_PRIV("DSA Private", 2, Arrays.asList(1024), 48),
    DSA_PUB("DSA Public", 3, Arrays.asList(1024), 48),
    RSA_PRIV("RSA Private", 4, Arrays.asList(4096, 2048, 1024), Arrays.asList(512, 256, 128)),
    RSA_PUB("RSA Public", 5, Arrays.asList(4096, 2048, 1024), Arrays.asList(512, 256, 128)),
    EC_PRIV("EC Private", 6, Arrays.asList(256, 384, 521, 192), 70),
    EC_PUB("EC Public", 7, Arrays.asList(256, 384, 521, 192), 70),
    TEST("Test", 127, Arrays.asList(1), 0);

    private final Map<Integer, Integer> outputSizeMap = new HashMap<Integer, Integer>();
    private final List<Integer> acceptableSizes;
    private final String name;
    @Expose
    private final int value;

    private KeyType(String n2, int v, List<Integer> sizes, int outputSize) {
        this.name = n2;
        this.value = v;
        this.acceptableSizes = sizes;
        for (int size : this.acceptableSizes) {
            this.outputSizeMap.put(size, outputSize);
        }
    }

    private KeyType(String n2, int v, List<Integer> sizes, List<Integer> outputSizeList) {
        this.name = n2;
        this.value = v;
        this.acceptableSizes = sizes;
        int i = 0;
        while (i < sizes.size()) {
            this.outputSizeMap.put(this.acceptableSizes.get(i), outputSizeList.get(i));
            ++i;
        }
    }

    public int defaultSize() {
        return this.acceptableSizes.get(0);
    }

    public int getOutputSize(int keySize) {
        return this.outputSizeMap.get(keySize);
    }

    public int getOutputSize() {
        return this.getOutputSize(this.defaultSize());
    }

    public boolean isAcceptableSize(int size) {
        return this.acceptableSizes.contains(size);
    }

    public List<Integer> getAcceptableSizes() {
        return Collections.unmodifiableList(this.acceptableSizes);
    }

    int getValue() {
        return this.value;
    }

    static KeyType getType(int value) {
        switch (value) {
            case 0: {
                return AES;
            }
            case 1: {
                return HMAC_SHA1;
            }
            case 2: {
                return DSA_PRIV;
            }
            case 3: {
                return DSA_PUB;
            }
            case 4: {
                return RSA_PRIV;
            }
            case 5: {
                return RSA_PUB;
            }
            case 6: {
                return EC_PRIV;
            }
            case 7: {
                return EC_PUB;
            }
            case 127: {
                return TEST;
            }
        }
        return null;
    }

    public String toString() {
        return this.name;
    }
}

