/*
 * Decompiled with CFR 0.152.
 */
package org.keyczar;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import org.apache.log4j.Logger;
import org.keyczar.Keyczar;
import org.keyczar.KeyczarKey;
import org.keyczar.StreamCache;
import org.keyczar.enums.KeyPurpose;
import org.keyczar.exceptions.BadVersionException;
import org.keyczar.exceptions.KeyNotFoundException;
import org.keyczar.exceptions.KeyczarException;
import org.keyczar.exceptions.ShortSignatureException;
import org.keyczar.i18n.Messages;
import org.keyczar.interfaces.KeyczarReader;
import org.keyczar.interfaces.VerifyingStream;
import org.keyczar.util.Base64Coder;

public class Verifier
extends Keyczar {
    private static final Logger LOG = Logger.getLogger(Verifier.class);
    private static final StreamCache<VerifyingStream> VERIFY_CACHE = new StreamCache();

    public Verifier(KeyczarReader reader) throws KeyczarException {
        super(reader);
    }

    public Verifier(String fileLocation) throws KeyczarException {
        super(fileLocation);
    }

    public boolean verify(byte[] data, byte[] signature) throws KeyczarException {
        return this.verify(ByteBuffer.wrap(data), ByteBuffer.wrap(signature));
    }

    public boolean verify(ByteBuffer data, ByteBuffer signature) throws KeyczarException {
        return this.verify(data, null, signature);
    }

    boolean verify(ByteBuffer data, ByteBuffer hidden, ByteBuffer signature) throws KeyczarException {
        LOG.debug((Object)Messages.getString("Verifier.Verifying", data.remaining()));
        if (signature.remaining() < 5) {
            throw new ShortSignatureException(signature.remaining());
        }
        byte version = signature.get();
        if (version != 0) {
            throw new BadVersionException(version);
        }
        byte[] hash = new byte[4];
        signature.get(hash);
        KeyczarKey key = this.getKey(hash);
        if (key == null) {
            throw new KeyNotFoundException(hash);
        }
        VerifyingStream stream = VERIFY_CACHE.get(key);
        if (stream == null) {
            stream = (VerifyingStream)key.getStream();
        }
        stream.initVerify();
        if (hidden != null) {
            stream.updateVerify(hidden);
        }
        stream.updateVerify(data);
        stream.updateVerify(ByteBuffer.wrap(FORMAT_BYTES));
        boolean result = stream.verify(signature);
        VERIFY_CACHE.put(key, stream);
        return result;
    }

    public boolean verify(String data, String signature) throws KeyczarException {
        try {
            return this.verify(data.getBytes("UTF-8"), Base64Coder.decode(signature));
        }
        catch (UnsupportedEncodingException e) {
            throw new KeyczarException(e);
        }
    }

    boolean isAcceptablePurpose(KeyPurpose purpose) {
        return purpose == KeyPurpose.VERIFY || purpose == KeyPurpose.SIGN_AND_VERIFY;
    }
}

