/*
 * Decompiled with CFR 0.152.
 */
package org.keyczar;

import java.util.concurrent.ConcurrentHashMap;
import org.keyczar.KeyczarKey;
import org.keyczar.StreamQueue;
import org.keyczar.interfaces.Stream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class StreamCache<T extends Stream> {
    private final ConcurrentHashMap<KeyczarKey, StreamQueue<T>> cacheMap = new ConcurrentHashMap();

    StreamCache() {
    }

    void put(KeyczarKey key, T s) {
        this.getQueue(key).add(s);
    }

    T get(KeyczarKey key) {
        return (T)((Stream)this.getQueue(key).poll());
    }

    StreamQueue<T> getQueue(KeyczarKey key) {
        StreamQueue<T> queue = this.cacheMap.get(key);
        if (queue != null) {
            return queue;
        }
        StreamQueue freshQueue = new StreamQueue();
        queue = this.cacheMap.putIfAbsent(key, freshQueue);
        if (queue != null) {
            return queue;
        }
        return freshQueue;
    }
}

