/*
 * Decompiled with CFR 0.152.
 */
package org.keyczar;

import com.google.gson.annotations.Expose;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.spec.RSAPrivateCrtKeySpec;
import javax.crypto.Cipher;
import javax.crypto.ShortBufferException;
import org.keyczar.KeyczarKey;
import org.keyczar.KeyczarPrivateKey;
import org.keyczar.KeyczarPublicKey;
import org.keyczar.RsaPublicKey;
import org.keyczar.enums.KeyType;
import org.keyczar.exceptions.KeyczarException;
import org.keyczar.interfaces.DecryptingStream;
import org.keyczar.interfaces.EncryptingStream;
import org.keyczar.interfaces.SigningStream;
import org.keyczar.interfaces.Stream;
import org.keyczar.interfaces.VerifyingStream;
import org.keyczar.util.Base64Coder;
import org.keyczar.util.Util;

class RsaPrivateKey
extends KeyczarKey
implements KeyczarPrivateKey {
    private static final String CRYPT_ALGORITHM = "RSA/ECB/OAEPWITHSHA1ANDMGF1PADDING";
    private static final String KEY_GEN_ALGORITHM = "RSA";
    @Expose
    private RsaPublicKey publicKey = new RsaPublicKey();
    @Expose
    private String privateExponent;
    @Expose
    private String primeP;
    @Expose
    private String primeQ;
    @Expose
    private String primeExponentP;
    @Expose
    private String primeExponentQ;
    @Expose
    private String crtCoefficient;
    private static final String SIG_ALGORITHM = "SHA1withRSA";
    private RSAPrivateCrtKey jcePrivateKey;

    private RsaPrivateKey() {
    }

    Stream getStream() throws KeyczarException {
        return new RsaPrivateStream();
    }

    KeyType getType() {
        return KeyType.RSA_PRIV;
    }

    byte[] hash() {
        return this.publicKey.hash();
    }

    static RsaPrivateKey read(String input) throws KeyczarException {
        RsaPrivateKey key = (RsaPrivateKey)Util.gson().fromJson(input, RsaPrivateKey.class);
        key.init();
        return key;
    }

    static RsaPrivateKey generate() throws KeyczarException {
        return RsaPrivateKey.generate(KeyType.RSA_PRIV.defaultSize());
    }

    public KeyczarPublicKey getPublic() {
        return this.publicKey;
    }

    private void init() throws KeyczarException {
        try {
            KeyFactory factory = KeyFactory.getInstance(KEY_GEN_ALGORITHM);
            BigInteger mod = new BigInteger(Base64Coder.decode(this.publicKey.modulus));
            BigInteger pubExp = new BigInteger(Base64Coder.decode(this.publicKey.publicExponent));
            this.publicKey.set(this.size, mod, pubExp);
            BigInteger privExp = new BigInteger(Base64Coder.decode(this.privateExponent));
            BigInteger p = new BigInteger(Base64Coder.decode(this.primeP));
            BigInteger q = new BigInteger(Base64Coder.decode(this.primeQ));
            BigInteger expP = new BigInteger(Base64Coder.decode(this.primeExponentP));
            BigInteger expQ = new BigInteger(Base64Coder.decode(this.primeExponentQ));
            BigInteger crt = new BigInteger(Base64Coder.decode(this.crtCoefficient));
            RSAPrivateCrtKeySpec spec = new RSAPrivateCrtKeySpec(mod, pubExp, privExp, p, q, expP, expQ, crt);
            this.jcePrivateKey = (RSAPrivateCrtKey)factory.generatePrivate(spec);
        }
        catch (GeneralSecurityException e) {
            throw new KeyczarException(e);
        }
    }

    static RsaPrivateKey generate(int keySize) throws KeyczarException {
        RsaPrivateKey key = new RsaPrivateKey();
        try {
            KeyPairGenerator kpg = KeyPairGenerator.getInstance(KEY_GEN_ALGORITHM);
            key.publicKey.size = key.size = keySize;
            kpg.initialize(key.size());
            KeyPair pair = kpg.generateKeyPair();
            key.jcePrivateKey = (RSAPrivateCrtKey)pair.getPrivate();
            key.publicKey.set(key.size, key.jcePrivateKey.getModulus(), key.jcePrivateKey.getPublicExponent());
        }
        catch (GeneralSecurityException e) {
            throw new KeyczarException(e);
        }
        key.privateExponent = Base64Coder.encode(key.jcePrivateKey.getPrivateExponent().toByteArray());
        key.primeP = Base64Coder.encode(key.jcePrivateKey.getPrimeP().toByteArray());
        key.primeQ = Base64Coder.encode(key.jcePrivateKey.getPrimeQ().toByteArray());
        key.primeExponentP = Base64Coder.encode(key.jcePrivateKey.getPrimeExponentP().toByteArray());
        key.primeExponentQ = Base64Coder.encode(key.jcePrivateKey.getPrimeExponentQ().toByteArray());
        key.crtCoefficient = Base64Coder.encode(key.jcePrivateKey.getCrtCoefficient().toByteArray());
        return key;
    }

    private class RsaPrivateStream
    implements SigningStream,
    VerifyingStream,
    DecryptingStream,
    EncryptingStream {
        private Cipher cipher;
        private EncryptingStream encryptingStream;
        private Signature signature;
        private VerifyingStream verifyingStream;

        public RsaPrivateStream() throws KeyczarException {
            try {
                this.signature = Signature.getInstance(RsaPrivateKey.SIG_ALGORITHM);
                this.verifyingStream = (VerifyingStream)RsaPrivateKey.this.publicKey.getStream();
                this.cipher = Cipher.getInstance(RsaPrivateKey.CRYPT_ALGORITHM);
                this.encryptingStream = (EncryptingStream)RsaPrivateKey.this.publicKey.getStream();
            }
            catch (GeneralSecurityException e) {
                throw new KeyczarException(e);
            }
        }

        public int digestSize() {
            return RsaPrivateKey.this.getType().getOutputSize();
        }

        public int doFinalDecrypt(ByteBuffer input, ByteBuffer output) throws KeyczarException {
            try {
                return this.cipher.doFinal(input, output);
            }
            catch (GeneralSecurityException e) {
                throw new KeyczarException(e);
            }
        }

        public int doFinalEncrypt(ByteBuffer input, ByteBuffer output) throws KeyczarException {
            return this.encryptingStream.doFinalEncrypt(input, output);
        }

        public SigningStream getSigningStream() throws KeyczarException {
            return this.encryptingStream.getSigningStream();
        }

        public VerifyingStream getVerifyingStream() {
            return new VerifyingStream(){

                public int digestSize() {
                    return 0;
                }

                public void initVerify() {
                }

                public void updateVerify(ByteBuffer input) {
                }

                public boolean verify(ByteBuffer signature) {
                    return true;
                }
            };
        }

        public void initDecrypt(ByteBuffer input) throws KeyczarException {
            try {
                this.cipher.init(2, RsaPrivateKey.this.jcePrivateKey);
            }
            catch (InvalidKeyException e) {
                throw new KeyczarException(e);
            }
        }

        public int initEncrypt(ByteBuffer output) throws KeyczarException {
            return this.encryptingStream.initEncrypt(output);
        }

        public void initSign() throws KeyczarException {
            try {
                this.signature.initSign(RsaPrivateKey.this.jcePrivateKey);
            }
            catch (GeneralSecurityException e) {
                throw new KeyczarException(e);
            }
        }

        public void initVerify() throws KeyczarException {
            this.verifyingStream.initVerify();
        }

        public int maxOutputSize(int inputLen) {
            return RsaPrivateKey.this.getType().getOutputSize(RsaPrivateKey.this.size);
        }

        public void sign(ByteBuffer output) throws KeyczarException {
            try {
                byte[] sig = this.signature.sign();
                output.put(sig);
            }
            catch (SignatureException e) {
                throw new KeyczarException(e);
            }
        }

        public int updateDecrypt(ByteBuffer input, ByteBuffer output) throws KeyczarException {
            try {
                return this.cipher.update(input, output);
            }
            catch (ShortBufferException e) {
                throw new KeyczarException(e);
            }
        }

        public int updateEncrypt(ByteBuffer input, ByteBuffer output) throws KeyczarException {
            return this.encryptingStream.updateEncrypt(input, output);
        }

        public void updateSign(ByteBuffer input) throws KeyczarException {
            try {
                this.signature.update(input);
            }
            catch (SignatureException e) {
                throw new KeyczarException(e);
            }
        }

        public void updateVerify(ByteBuffer input) throws KeyczarException {
            this.verifyingStream.updateVerify(input);
        }

        public boolean verify(ByteBuffer sig) throws KeyczarException {
            return this.verifyingStream.verify(sig);
        }
    }
}

