/*
 * Decompiled with CFR 0.152.
 */
package org.keyczar;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.keyczar.Crypter;
import org.keyczar.Encrypter;
import org.keyczar.GenericKeyczar;
import org.keyczar.KeyMetadata;
import org.keyczar.KeyVersion;
import org.keyczar.KeyczarEncryptedReader;
import org.keyczar.KeyczarFileReader;
import org.keyczar.MockKeyczarReader;
import org.keyczar.Signer;
import org.keyczar.enums.Command;
import org.keyczar.enums.Flag;
import org.keyczar.enums.KeyPurpose;
import org.keyczar.enums.KeyStatus;
import org.keyczar.enums.KeyType;
import org.keyczar.exceptions.KeyczarException;
import org.keyczar.i18n.Messages;
import org.keyczar.interfaces.KeyczarReader;

public class KeyczarTool {
    static MockKeyczarReader mock = null;

    public static void setReader(MockKeyczarReader reader) {
        mock = reader;
    }

    public static MockKeyczarReader getMock() {
        return mock;
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            KeyczarTool.printUsage();
        } else {
            try {
                Command c = Command.getCommand(args[0]);
                HashMap<Flag, String> flagMap = new HashMap<Flag, String>();
                String[] stringArray = args;
                int n = args.length;
                int n2 = 0;
                while (n2 < n) {
                    String[] nameValuePair;
                    String arg = stringArray[n2];
                    if (arg.startsWith("--") && (nameValuePair = (arg = arg.substring(2)).split("=")).length > 1) {
                        Flag f = Flag.getFlag(nameValuePair[0]);
                        flagMap.put(f, nameValuePair[1]);
                    }
                    ++n2;
                }
                String locationFlag = (String)flagMap.get((Object)Flag.LOCATION);
                if (locationFlag != null && !locationFlag.endsWith(File.separator)) {
                    locationFlag = String.valueOf(locationFlag) + File.separator;
                }
                switch (c) {
                    case CREATE: {
                        String nameFlag = (String)flagMap.get((Object)Flag.NAME);
                        KeyPurpose purposeFlag = KeyPurpose.getPurpose((String)flagMap.get((Object)Flag.PURPOSE));
                        String asymmetricFlag = (String)flagMap.get((Object)Flag.ASYMMETRIC);
                        KeyczarTool.create(locationFlag, nameFlag, purposeFlag, asymmetricFlag);
                        break;
                    }
                    case ADDKEY: {
                        KeyStatus statusFlag = KeyStatus.getStatus((String)flagMap.get((Object)Flag.STATUS));
                        String crypterFlag = (String)flagMap.get((Object)Flag.CRYPTER);
                        int sizeFlag = -1;
                        if (flagMap.containsKey((Object)Flag.SIZE)) {
                            sizeFlag = Integer.parseInt((String)flagMap.get((Object)Flag.SIZE));
                        }
                        KeyczarTool.addKey(locationFlag, statusFlag, crypterFlag, sizeFlag);
                        break;
                    }
                    case PUBKEY: {
                        KeyczarTool.publicKeys(locationFlag, (String)flagMap.get((Object)Flag.DESTINATION));
                        break;
                    }
                    case PROMOTE: {
                        KeyczarTool.promote(locationFlag, Integer.parseInt((String)flagMap.get((Object)Flag.VERSION)));
                        break;
                    }
                    case DEMOTE: {
                        KeyczarTool.demote(locationFlag, Integer.parseInt((String)flagMap.get((Object)Flag.VERSION)));
                        break;
                    }
                    case REVOKE: {
                        KeyczarTool.revoke(locationFlag, Integer.parseInt((String)flagMap.get((Object)Flag.VERSION)));
                        break;
                    }
                    case USEKEY: {
                        if (args.length > 2) {
                            KeyczarTool.useKey(args[1], locationFlag, (String)flagMap.get((Object)Flag.DESTINATION), (String)flagMap.get((Object)Flag.CRYPTER));
                            break;
                        }
                        KeyczarTool.printUsage();
                    }
                }
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                KeyczarTool.printUsage();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                KeyczarTool.printUsage();
            }
            catch (NullPointerException e) {
                e.printStackTrace();
                KeyczarTool.printUsage();
            }
            catch (KeyczarException e) {
                e.printStackTrace();
                KeyczarTool.printUsage();
            }
        }
    }

    private static void useKey(String msg, String locationFlag, String destinationFlag, String crypterFlag) throws KeyczarException {
        GenericKeyczar genericKeyczar = KeyczarTool.createGenericKeyczar(locationFlag, crypterFlag);
        if (destinationFlag == null) {
            throw new KeyczarException(Messages.getString("KeyczarTool.MustDefinePublic", new Object[0]));
        }
        String answer = "";
        KeyczarReader reader = new KeyczarFileReader(locationFlag);
        if (crypterFlag != null) {
            Crypter keyCrypter = new Crypter(crypterFlag);
            reader = new KeyczarEncryptedReader(reader, keyCrypter);
        }
        switch (genericKeyczar.getMetadata().getPurpose()) {
            case DECRYPT_AND_ENCRYPT: {
                Crypter crypter = new Crypter(reader);
                answer = crypter.encrypt(msg);
                break;
            }
            case SIGN_AND_VERIFY: {
                Signer signer = new Signer(reader);
                answer = signer.sign(msg);
                break;
            }
            default: {
                throw new KeyczarException(Messages.getString("KeyczarTool.UnsupportedPurpose", new Object[]{genericKeyczar.getMetadata().getPurpose()}));
            }
        }
        genericKeyczar.writeFile(answer, destinationFlag);
    }

    private static void addKey(String locationFlag, KeyStatus statusFlag, String crypterFlag, int sizeFlag) throws KeyczarException {
        GenericKeyczar genericKeyczar = KeyczarTool.createGenericKeyczar(locationFlag, crypterFlag);
        if (sizeFlag == -1) {
            genericKeyczar.addVersion(statusFlag);
        } else {
            genericKeyczar.addVersion(statusFlag, sizeFlag);
        }
        if (crypterFlag != null) {
            Encrypter encrypter = new Encrypter(crypterFlag);
            KeyczarTool.updateGenericKeyczar(genericKeyczar, encrypter, locationFlag);
        } else {
            KeyczarTool.updateGenericKeyczar(genericKeyczar, locationFlag);
        }
    }

    private static void create(String locationFlag, String nameFlag, KeyPurpose purposeFlag, String asymmetricFlag) throws KeyczarException {
        KeyMetadata kmd = null;
        if (purposeFlag == null) {
            throw new KeyczarException(Messages.getString("KeyczarTool.MustDefinePurpose", new Object[0]));
        }
        switch (purposeFlag) {
            case TEST: {
                kmd = new KeyMetadata(nameFlag, KeyPurpose.TEST, KeyType.TEST);
                break;
            }
            case SIGN_AND_VERIFY: {
                if (asymmetricFlag != null) {
                    if (asymmetricFlag.equalsIgnoreCase("rsa")) {
                        kmd = new KeyMetadata(nameFlag, KeyPurpose.SIGN_AND_VERIFY, KeyType.RSA_PRIV);
                        break;
                    }
                    if (asymmetricFlag.equalsIgnoreCase("ec")) {
                        kmd = new KeyMetadata(nameFlag, KeyPurpose.SIGN_AND_VERIFY, KeyType.EC_PRIV);
                        break;
                    }
                    kmd = new KeyMetadata(nameFlag, KeyPurpose.SIGN_AND_VERIFY, KeyType.DSA_PRIV);
                    break;
                }
                kmd = new KeyMetadata(nameFlag, KeyPurpose.SIGN_AND_VERIFY, KeyType.HMAC_SHA1);
                break;
            }
            case DECRYPT_AND_ENCRYPT: {
                kmd = asymmetricFlag != null ? new KeyMetadata(nameFlag, KeyPurpose.DECRYPT_AND_ENCRYPT, KeyType.RSA_PRIV) : new KeyMetadata(nameFlag, KeyPurpose.DECRYPT_AND_ENCRYPT, KeyType.AES);
            }
        }
        if (kmd == null) {
            throw new KeyczarException(Messages.getString("KeyczarTool.UnsupportedPurpose", new Object[]{purposeFlag}));
        }
        if (mock == null) {
            if (locationFlag == null) {
                throw new KeyczarException(Messages.getString("KeyczarTool.MustDefineLocation", new Object[0]));
            }
            File file = new File(String.valueOf(locationFlag) + "meta");
            if (file.exists()) {
                throw new KeyczarException(Messages.getString("KeyczarTool.FileExists", file));
            }
            try {
                FileOutputStream metaOutput = new FileOutputStream(file);
                metaOutput.write(kmd.toString().getBytes("UTF-8"));
                metaOutput.close();
            }
            catch (IOException e) {
                throw new KeyczarException(Messages.getString("KeyczarTool.UnableToWrite", file.toString()), e);
            }
        } else {
            mock.setMetadata(kmd);
        }
    }

    private static void promote(String locationFlag, int versionFlag) throws KeyczarException {
        if (versionFlag < 0) {
            throw new KeyczarException(Messages.getString("KeyczarTool.MissingVersion", new Object[0]));
        }
        GenericKeyczar genericKeyczar = KeyczarTool.createGenericKeyczar(locationFlag);
        genericKeyczar.promote(versionFlag);
        KeyczarTool.updateGenericKeyczar(genericKeyczar, locationFlag);
    }

    private static void demote(String locationFlag, int versionFlag) throws KeyczarException {
        if (versionFlag < 0) {
            throw new KeyczarException(Messages.getString("KeyczarTool.MissingVersion", new Object[0]));
        }
        GenericKeyczar genericKeyczar = KeyczarTool.createGenericKeyczar(locationFlag);
        genericKeyczar.demote(versionFlag);
        KeyczarTool.updateGenericKeyczar(genericKeyczar, locationFlag);
    }

    private static void publicKeys(String locationFlag, String destinationFlag) throws KeyczarException {
        if (mock == null && destinationFlag == null) {
            throw new KeyczarException(Messages.getString("KeyczarTool.MustDefineDestination", new Object[0]));
        }
        GenericKeyczar genericKeyczar = KeyczarTool.createGenericKeyczar(locationFlag);
        genericKeyczar.publicKeyExport(destinationFlag);
    }

    private static void revoke(String locationFlag, int versionFlag) throws KeyczarException {
        GenericKeyczar genericKeyczar = KeyczarTool.createGenericKeyczar(locationFlag);
        genericKeyczar.revoke(versionFlag);
        KeyczarTool.updateGenericKeyczar(genericKeyczar, locationFlag);
        if (mock == null) {
            File revokedVersion = new File(String.valueOf(locationFlag) + versionFlag);
            if (!revokedVersion.delete()) {
                throw new KeyczarException(Messages.getString("KeyczarTool.UnableToDelete", new Object[0]));
            }
        } else {
            mock.removeKey(versionFlag);
        }
    }

    private static void printUsage() {
        ArrayList<String> usageParams = new ArrayList<String>();
        Enum[] enumArray = Command.values();
        int n = enumArray.length;
        int n2 = 0;
        while (n2 < n) {
            Command c = enumArray[n2];
            usageParams.add(c.toString());
            ++n2;
        }
        enumArray = Flag.values();
        n = enumArray.length;
        n2 = 0;
        while (n2 < n) {
            Enum f = enumArray[n2];
            usageParams.add(((Flag)f).toString());
            ++n2;
        }
        System.out.println(Messages.getString("KeyczarTool.Usage", usageParams.toArray()));
    }

    private static GenericKeyczar createGenericKeyczar(String locationFlag) throws KeyczarException {
        return KeyczarTool.createGenericKeyczar(locationFlag, null);
    }

    private static GenericKeyczar createGenericKeyczar(String locationFlag, String crypterFlag) throws KeyczarException {
        if (mock != null) {
            return new GenericKeyczar(mock);
        }
        if (locationFlag == null) {
            throw new KeyczarException(Messages.getString("KeyczarTool.NeedLocation", Messages.getString("KeyczarTool.Location", new Object[0])));
        }
        KeyczarReader reader = new KeyczarFileReader(locationFlag);
        if (crypterFlag != null) {
            Crypter keyDecrypter = new Crypter(crypterFlag);
            reader = new KeyczarEncryptedReader(reader, keyDecrypter);
        }
        return new GenericKeyczar(reader);
    }

    private static void updateGenericKeyczar(GenericKeyczar genericKeyczar, String locationFlag) throws KeyczarException {
        KeyczarTool.updateGenericKeyczar(genericKeyczar, null, locationFlag);
    }

    private static void updateGenericKeyczar(GenericKeyczar genericKeyczar, Encrypter encrypter, String locationFlag) throws KeyczarException {
        if (mock != null) {
            mock.setMetadata(genericKeyczar.getMetadata());
            for (KeyVersion version : genericKeyczar.getVersions()) {
                mock.setKey(version.getVersionNumber(), genericKeyczar.getKey(version));
            }
        } else if (encrypter != null) {
            genericKeyczar.writeEncrypted(locationFlag, encrypter);
        } else {
            genericKeyczar.write(locationFlag);
        }
    }
}

