/*
 * Decompiled with CFR 0.152.
 */
package org.keyczar;

import com.google.gson.annotations.Expose;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.keyczar.AesKey;
import org.keyczar.DsaPrivateKey;
import org.keyczar.DsaPublicKey;
import org.keyczar.HmacKey;
import org.keyczar.RsaPrivateKey;
import org.keyczar.RsaPublicKey;
import org.keyczar.enums.KeyType;
import org.keyczar.exceptions.KeyczarException;
import org.keyczar.exceptions.UnsupportedTypeException;
import org.keyczar.i18n.Messages;
import org.keyczar.interfaces.Stream;
import org.keyczar.util.Util;

abstract class KeyczarKey {
    @Expose
    int size = this.getType().defaultSize();

    KeyczarKey() {
    }

    void copyHeader(ByteBuffer dest) {
        dest.put((byte)0);
        dest.put(this.hash());
    }

    public boolean equals(Object o) {
        try {
            KeyczarKey key = (KeyczarKey)o;
            return Arrays.equals(key.hash(), this.hash());
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public int hashCode() {
        return Util.toInt(this.hash());
    }

    abstract Stream getStream() throws KeyczarException;

    abstract KeyType getType();

    abstract byte[] hash();

    int size() {
        return this.size;
    }

    static KeyczarKey genKey(KeyType type) throws KeyczarException {
        return KeyczarKey.genKey(type, type.defaultSize());
    }

    public String toString() {
        return Util.gson().toJson((Object)this);
    }

    static KeyczarKey genKey(KeyType type, int keySize) throws KeyczarException {
        if (!type.isAcceptableSize(keySize)) {
            keySize = type.defaultSize();
        }
        switch (type) {
            case AES: {
                return AesKey.generate(keySize);
            }
            case HMAC_SHA1: {
                return HmacKey.generate(keySize);
            }
            case DSA_PRIV: {
                return DsaPrivateKey.generate(keySize);
            }
            case RSA_PRIV: {
                return RsaPrivateKey.generate(keySize);
            }
            case DSA_PUB: 
            case RSA_PUB: {
                throw new KeyczarException(Messages.getString("KeyczarKey.PublicKeyExport", new Object[]{type}));
            }
        }
        throw new UnsupportedTypeException(type);
    }

    static KeyczarKey readKey(KeyType type, String key) throws KeyczarException {
        switch (type) {
            case AES: {
                return AesKey.read(key);
            }
            case HMAC_SHA1: {
                return HmacKey.read(key);
            }
            case DSA_PRIV: {
                return DsaPrivateKey.read(key);
            }
            case DSA_PUB: {
                return DsaPublicKey.read(key);
            }
            case RSA_PRIV: {
                return RsaPrivateKey.read(key);
            }
            case RSA_PUB: {
                return RsaPublicKey.read(key);
            }
        }
        throw new UnsupportedTypeException(type);
    }
}

