/*
 * Decompiled with CFR 0.152.
 */
package org.keyczar;

import java.util.HashMap;
import org.apache.log4j.Logger;
import org.keyczar.KeyMetadata;
import org.keyczar.KeyVersion;
import org.keyczar.KeyczarFileReader;
import org.keyczar.KeyczarKey;
import org.keyczar.enums.KeyPurpose;
import org.keyczar.enums.KeyStatus;
import org.keyczar.exceptions.KeyczarException;
import org.keyczar.i18n.Messages;
import org.keyczar.interfaces.EncryptedReader;
import org.keyczar.interfaces.KeyczarReader;
import org.keyczar.util.Util;

abstract class Keyczar {
    private static final Logger LOG = Logger.getLogger(Keyczar.class);
    static final String DEFAULT_ENCODING = "UTF-8";
    static final byte FORMAT_VERSION = 0;
    static final byte[] FORMAT_BYTES = new byte[1];
    static final int KEY_HASH_SIZE = 4;
    static final int HEADER_SIZE = 5;
    final KeyMetadata kmd;
    KeyVersion primaryVersion;
    final HashMap<KeyVersion, KeyczarKey> versionMap = new HashMap();
    final HashMap<KeyHash, KeyczarKey> hashMap = new HashMap();

    public Keyczar(KeyczarReader reader) throws KeyczarException {
        this.kmd = KeyMetadata.read(reader.getMetadata());
        if (!this.isAcceptablePurpose(this.kmd.getPurpose())) {
            throw new KeyczarException(Messages.getString("Keyczar.UnacceptablePurpose", new Object[]{this.kmd.getPurpose()}));
        }
        if (this.kmd.isEncrypted() && !(reader instanceof EncryptedReader)) {
            throw new KeyczarException(Messages.getString("Keyczar.NeedEncryptedReader", new Object[0]));
        }
        for (KeyVersion version : this.kmd.getVersions()) {
            if (version.getStatus() == KeyStatus.PRIMARY) {
                if (this.primaryVersion != null) {
                    throw new KeyczarException(Messages.getString("Keyczar.SinglePrimary", new Object[0]));
                }
                this.primaryVersion = version;
            }
            KeyczarKey key = KeyczarKey.readKey(this.kmd.getType(), reader.getKey(version.getVersionNumber()));
            LOG.debug((Object)Messages.getString("Keyczar.ReadVersion", version));
            this.hashMap.put(new KeyHash(key.hash()), key);
            this.versionMap.put(version, key);
        }
    }

    public Keyczar(String fileLocation) throws KeyczarException {
        this(new KeyczarFileReader(fileLocation));
    }

    public String toString() {
        return this.kmd.toString();
    }

    void addKey(KeyVersion version, KeyczarKey key) {
        this.hashMap.put(new KeyHash(key.hash()), key);
        this.versionMap.put(version, key);
        this.kmd.addVersion(version);
    }

    KeyczarKey getPrimaryKey() {
        if (this.primaryVersion == null) {
            return null;
        }
        return this.versionMap.get(this.primaryVersion);
    }

    KeyczarKey getKey(byte[] hash) {
        return this.hashMap.get(new KeyHash(hash));
    }

    abstract boolean isAcceptablePurpose(KeyPurpose var1);

    private class KeyHash {
        private byte[] data;

        private KeyHash(byte[] d) {
            if (d.length != 4) {
                throw new IllegalArgumentException();
            }
            this.data = d;
        }

        public boolean equals(Object o) {
            return o instanceof KeyHash && o.hashCode() == this.hashCode();
        }

        public int hashCode() {
            return Util.toInt(this.data);
        }
    }
}

