/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.tests;

import java.io.FileInputStream;
import java.security.MessageDigest;
import java.security.Provider;
import java.security.Security;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.util.Debug;

public class DigestTest {
    static final String MOZ_PROVIDER_NAME = "Mozilla-JSS";
    static final String[] JSS_Digest_Algs = new String[]{"MD2", "MD5", "SHA-1", "SHA-256", "SHA-384", "SHA-512"};

    public static boolean messageDigestCompare(String string, byte[] byArray) throws Exception {
        boolean bl = false;
        MessageDigest messageDigest = MessageDigest.getInstance(string, MOZ_PROVIDER_NAME);
        byte[] byArray2 = messageDigest.digest(byArray);
        Provider[] providerArray = Security.getProviders("MessageDigest." + string);
        String string2 = null;
        for (int i = 0; i < providerArray.length; ++i) {
            string2 = providerArray[i].getName();
            if (string2.equals(MOZ_PROVIDER_NAME)) continue;
            MessageDigest messageDigest2 = MessageDigest.getInstance(string, string2);
            byte[] byArray3 = messageDigest2.digest(byArray);
            if (MessageDigest.isEqual(byArray2, byArray3)) {
                System.out.println(string2 + " and " + MOZ_PROVIDER_NAME + " give same " + string + " message digests");
                bl = true;
                continue;
            }
            throw new Exception("ERROR: " + string2 + " and " + MOZ_PROVIDER_NAME + " give different " + string + " message digests");
        }
        return bl;
    }

    public static boolean testJSSDigest(String string, byte[] byArray) throws Exception {
        MessageDigest messageDigest = MessageDigest.getInstance(string, MOZ_PROVIDER_NAME);
        byte[] byArray2 = messageDigest.digest(byArray);
        if (byArray2.length != messageDigest.getDigestLength()) {
            throw new Exception("ERROR: digest output size is " + byArray2.length + ", should be " + messageDigest.getDigestLength());
        }
        System.out.println(messageDigest.getAlgorithm() + " " + " digest output size is " + byArray2.length);
        return true;
    }

    public static void main(String[] stringArray) {
        try {
            if (stringArray.length != 2) {
                System.out.println("Usage: java org.mozilla.jss.tests.DigestTest <dbdir> <File>");
                System.exit(1);
            }
            String string = stringArray[0];
            FileInputStream fileInputStream = new FileInputStream(stringArray[1]);
            byte[] byArray = new byte[fileInputStream.available()];
            int n = fileInputStream.read(byArray);
            System.out.println(n + " bytes to be digested");
            CryptoManager.initialize(string);
            Debug.setLevel(10);
            String string2 = System.getProperty("java.version");
            System.out.println("The Java version is: " + string2);
            for (int i = 0; i < JSS_Digest_Algs.length; ++i) {
                if (DigestTest.messageDigestCompare(JSS_Digest_Algs[i], byArray)) continue;
                DigestTest.testJSSDigest(JSS_Digest_Algs[i], byArray);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }
}

