/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.provider.java.security;

import java.io.IOException;
import java.security.AlgorithmParametersSpi;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.spec.RC2ParameterSpec;
import org.mozilla.jss.util.Assert;

public class RC2AlgorithmParameters
extends AlgorithmParametersSpi {
    private RC2ParameterSpec RC2ParamSpec;

    public void engineInit(AlgorithmParameterSpec algorithmParameterSpec) {
        this.RC2ParamSpec = (RC2ParameterSpec)algorithmParameterSpec;
    }

    public AlgorithmParameterSpec engineGetParameterSpec(Class clazz) throws InvalidParameterSpecException {
        if (clazz != null && !clazz.isInstance(this.RC2ParamSpec)) {
            Class<?> clazz2 = this.RC2ParamSpec.getClass();
            throw new InvalidParameterSpecException("RC2 getParameterSpec has class " + clazz2.getName());
        }
        return this.RC2ParamSpec;
    }

    public void engineInit(byte[] byArray) throws IOException {
        Assert.notReached("engineInit(byte[]) not supported");
        throw new IOException("engineInit(byte[]) not supported");
    }

    public void engineInit(byte[] byArray, String string) throws IOException {
        Assert.notReached("engineInit(byte[],String) not supported");
        throw new IOException("engineInit(byte[],String) not supported");
    }

    public byte[] engineGetEncoded() throws IOException {
        Assert.notReached("encoding RC2AlgorithmParameters not supported");
        throw new IOException("encoding RC2AlgorithmParameters not supported");
    }

    public byte[] engineGetEncoded(String string) throws IOException {
        Assert.notReached("encoding RC2AlgorithmParameters not supported");
        throw new IOException("encoding RC2AlgorithmParameters not supported");
    }

    public String engineToString() {
        String string = new String("Mozilla-JSS RC2AlgorithmParameters " + this.getClass().getName());
        return string;
    }
}

