/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.provider.java.security;

import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.KeyPairAlgorithm;
import org.mozilla.jss.crypto.KeyPairGenerator;
import org.mozilla.jss.crypto.TokenException;
import org.mozilla.jss.crypto.TokenRuntimeException;
import org.mozilla.jss.crypto.TokenSupplierManager;

class JSSKeyPairGeneratorSpi
extends KeyPairGeneratorSpi {
    private KeyPairGenerator kpg;

    private JSSKeyPairGeneratorSpi() {
    }

    protected JSSKeyPairGeneratorSpi(KeyPairAlgorithm keyPairAlgorithm) {
        CryptoToken cryptoToken = TokenSupplierManager.getTokenSupplier().getThreadToken();
        try {
            try {
                this.kpg = cryptoToken.getKeyPairGenerator(keyPairAlgorithm);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new UnsupportedOperationException("Token '" + cryptoToken.getName() + "' does not support algorithm " + keyPairAlgorithm.toString());
            }
        }
        catch (TokenException tokenException) {
            throw new TokenRuntimeException(tokenException.getMessage());
        }
    }

    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        this.kpg.initialize(algorithmParameterSpec, secureRandom);
    }

    public void initialize(int n, SecureRandom secureRandom) {
        this.kpg.initialize(n, secureRandom);
    }

    public KeyPair generateKeyPair() {
        try {
            return this.kpg.genKeyPair();
        }
        catch (TokenException tokenException) {
            throw new TokenRuntimeException(tokenException.getMessage());
        }
    }

    public static class EC
    extends JSSKeyPairGeneratorSpi {
        public EC() {
            super(KeyPairAlgorithm.EC);
        }
    }

    public static class DSA
    extends JSSKeyPairGeneratorSpi {
        public DSA() {
            super(KeyPairAlgorithm.DSA);
        }
    }

    public static class RSA
    extends JSSKeyPairGeneratorSpi {
        public RSA() {
            super(KeyPairAlgorithm.RSA);
        }
    }
}

