/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.asn1;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ASN1Header;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.Form;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.Tag;

public class OCTET_STRING
implements ASN1Value {
    public static final Tag TAG = new Tag(Tag.Class.UNIVERSAL, 4L);
    public static final Form FORM = Form.PRIMITIVE;
    byte[] data;
    private static final Template templateInstance = new Template();

    public Tag getTag() {
        return TAG;
    }

    private OCTET_STRING() {
    }

    public OCTET_STRING(byte[] byArray) {
        this.data = byArray;
    }

    public byte[] toByteArray() {
        return this.data;
    }

    public void encode(OutputStream outputStream) throws IOException {
        this.encode(this.getTag(), outputStream);
    }

    public void encode(Tag tag, OutputStream outputStream) throws IOException {
        ASN1Header aSN1Header = new ASN1Header(tag, FORM, this.data.length);
        aSN1Header.encode(outputStream);
        outputStream.write(this.data);
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public static class Template
    implements ASN1Template {
        public Tag getTag() {
            return TAG;
        }

        public boolean tagMatch(Tag tag) {
            return TAG.equals(tag);
        }

        public ASN1Value decode(InputStream inputStream) throws IOException, InvalidBERException {
            return this.decode(this.getTag(), inputStream);
        }

        protected ASN1Value generateInstance(byte[] byArray) {
            return new OCTET_STRING(byArray);
        }

        protected String getName() {
            return "OCTET_STRING";
        }

        public ASN1Value decode(Tag tag, InputStream inputStream) throws IOException, InvalidBERException {
            try {
                byte[] byArray;
                ASN1Header aSN1Header = new ASN1Header(inputStream);
                aSN1Header.validate(tag);
                if (aSN1Header.getContentLength() == -1L) {
                    ASN1Header aSN1Header2;
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    do {
                        if ((aSN1Header2 = ASN1Header.lookAhead(inputStream)).isEOC()) continue;
                        Template template = new Template();
                        OCTET_STRING oCTET_STRING = (OCTET_STRING)template.decode(inputStream);
                        byteArrayOutputStream.write(oCTET_STRING.toByteArray());
                    } while (!aSN1Header2.isEOC());
                    aSN1Header2 = new ASN1Header(inputStream);
                    byArray = byteArrayOutputStream.toByteArray();
                } else {
                    byArray = new byte[(int)aSN1Header.getContentLength()];
                    ASN1Util.readFully(byArray, inputStream);
                }
                return this.generateInstance(byArray);
            }
            catch (InvalidBERException invalidBERException) {
                throw new InvalidBERException(invalidBERException, this.getName());
            }
        }
    }
}

