/*
 * Decompiled with CFR 0.152.
 */
package org.keyczar.jce;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECFieldFp;
import java.security.spec.ECParameterSpec;
import org.keyczar.jce.EcCore;
import org.mozilla.jss.asn1.ANY;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.SEQUENCE;

public class EcSignatureImpl
extends SignatureSpi {
    MessageDigest hash;
    ECPrivateKey privateKey;
    ECPublicKey publicKey;
    ECParameterSpec params;

    private EcSignatureImpl(String digestName) throws NoSuchAlgorithmException {
        this.hash = MessageDigest.getInstance(digestName);
    }

    @Override
    protected Object engineGetParameter(String param) throws InvalidParameterException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        if (!(privateKey instanceof ECPrivateKey)) {
            throw new InvalidKeyException("Unsupported key type");
        }
        this.privateKey = (ECPrivateKey)privateKey;
        this.params = this.privateKey.getParams();
    }

    @Override
    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        if (!(publicKey instanceof ECPublicKey)) {
            throw new InvalidKeyException("Unsupported key type");
        }
        this.publicKey = (ECPublicKey)publicKey;
        this.params = this.publicKey.getParams();
    }

    @Override
    protected void engineSetParameter(String param, Object value) throws InvalidParameterException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        BigInteger n;
        BigInteger k;
        BigInteger e = EcSignatureImpl.trimHash(this.hash.digest(), this.params);
        BigInteger r = BigInteger.ZERO;
        BigInteger s = BigInteger.ZERO;
        do {
            n = this.params.getOrder();
            k = BigInteger.ZERO;
            while (true) {
                if ((k = new BigInteger(n.bitLength(), new SecureRandom()).mod(n)).signum() == 0) {
                    continue;
                }
                BigInteger[] G = EcCore.internalPoint(this.params.getGenerator());
                BigInteger[] R = EcCore.multiplyPoint(G, k, this.params);
                EcCore.toAffineX(R, this.params);
                r = R[0].mod(n);
                if (r.signum() != 0) break;
            }
        } while ((s = k.modInverse(n).multiply(e.add(this.privateKey.getS().multiply(r))).mod(n)).signum() == 0);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            SEQUENCE seq = new SEQUENCE();
            byte[] tmp = new byte[2 + (((ECFieldFp)this.params.getCurve().getField()).getFieldSize() + 7) / 8];
            tmp[0] = 2;
            tmp[1] = (byte)EcCore.fieldElemToBytes(r, this.params, tmp, 2);
            seq.addElement((ASN1Value)new ANY(tmp));
            tmp = new byte[2 + (((ECFieldFp)this.params.getCurve().getField()).getFieldSize() + 7) / 8];
            tmp[0] = 2;
            tmp[1] = (byte)EcCore.fieldElemToBytes(s, this.params, tmp, 2);
            seq.addElement((ASN1Value)new ANY(tmp));
            seq.encode((OutputStream)baos);
        }
        catch (Exception ex) {
            throw new SignatureException("Internal ASN.1 encoding error", ex);
        }
        return baos.toByteArray();
    }

    @Override
    protected void engineUpdate(byte b) {
        this.hash.update(b);
    }

    @Override
    protected void engineUpdate(byte[] b, int off, int len) {
        this.hash.update(b, off, len);
    }

    @Override
    protected boolean engineVerify(byte[] sigBytes) throws SignatureException {
        BigInteger n;
        BigInteger e;
        BigInteger s;
        BigInteger r;
        block5: {
            block4: {
                try {
                    SEQUENCE.Template foo = new SEQUENCE.Template();
                    foo.addElement((ASN1Template)ANY.getTemplate());
                    foo.addElement((ASN1Template)ANY.getTemplate());
                    SEQUENCE bar = (SEQUENCE)foo.decode((InputStream)new ByteArrayInputStream(sigBytes));
                    r = new BigInteger(1, ((ANY)bar.elementAt(0)).getContents());
                    s = new BigInteger(1, ((ANY)bar.elementAt(1)).getContents());
                    e = EcSignatureImpl.trimHash(this.hash.digest(), this.params);
                    n = this.params.getOrder();
                    if (r.compareTo(BigInteger.ONE) >= 0 && r.compareTo(n) < 0) break block4;
                    return false;
                }
                catch (Exception e2) {
                    throw new SignatureException("Internal error", e2);
                }
            }
            if (s.compareTo(BigInteger.ONE) >= 0 && s.compareTo(n) < 0) break block5;
            return false;
        }
        BigInteger c = s.modInverse(n);
        BigInteger u1 = e.multiply(c).mod(n);
        BigInteger u2 = r.multiply(c).mod(n);
        BigInteger[] G = EcCore.internalPoint(this.params.getGenerator());
        BigInteger[] W = EcCore.internalPoint(this.publicKey.getW());
        BigInteger[] R1 = EcCore.multiplyPoints(G, u1, W, u2, this.params);
        EcCore.toAffineX(R1, this.params);
        BigInteger v = R1[0].mod(n);
        return v.equals(r);
    }

    private static BigInteger trimHash(byte[] hash, ECParameterSpec params) {
        int hashLength;
        BigInteger e = new BigInteger(1, hash);
        int orderLength = params.getOrder().bitLength();
        if (orderLength < (hashLength = 8 * hash.length)) {
            e = e.shiftRight(hashLength - orderLength);
        }
        return e;
    }

    /* synthetic */ EcSignatureImpl(String string, EcSignatureImpl ecSignatureImpl) throws NoSuchAlgorithmException {
        this(string);
    }

    public static class SHA1
    extends EcSignatureImpl {
        public SHA1() throws NoSuchAlgorithmException {
            super("SHA-1", null);
        }
    }

    public static class SHA256
    extends EcSignatureImpl {
        public SHA256() throws NoSuchAlgorithmException {
            super("SHA-256", null);
        }
    }

    public static class SHA384
    extends EcSignatureImpl {
        public SHA384() throws NoSuchAlgorithmException {
            super("SHA-384", null);
        }
    }

    public static class SHA512
    extends EcSignatureImpl {
        public SHA512() throws NoSuchAlgorithmException {
            super("SHA-512", null);
        }
    }
}

