/*
 * Decompiled with CFR 0.152.
 */
package org.keyczar.jce;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import org.keyczar.jce.EcCore;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.BIT_STRING;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.asn1.SEQUENCE;

public class EcPublicKeyImpl
implements ECPublicKey {
    private static final long serialVersionUID = -2181476758766123036L;
    private BigInteger x;
    private BigInteger y;
    ECParameterSpec params;

    EcPublicKeyImpl(BigInteger x, BigInteger y, ECParameterSpec params) {
        this.x = x;
        this.y = y;
        this.params = params;
    }

    EcPublicKeyImpl(ECPoint W, ECParameterSpec params) {
        this.x = W.getAffineX();
        this.y = W.getAffineY();
        this.params = params;
    }

    @Override
    public ECPoint getW() {
        return new ECPoint(this.x, this.y);
    }

    @Override
    public String getAlgorithm() {
        return "EC";
    }

    @Override
    public byte[] getEncoded() {
        SEQUENCE outer = new SEQUENCE();
        SEQUENCE algid = new SEQUENCE();
        algid.addElement((ASN1Value)new OBJECT_IDENTIFIER("1.2.840.10045.2.1"));
        algid.addElement((ASN1Value)new OBJECT_IDENTIFIER(EcCore.getOID(this.params)));
        outer.addElement((ASN1Value)algid);
        BIT_STRING ecPublivKey = new BIT_STRING(EcCore.ecPointToBytes(this.getW(), this.params), 0);
        outer.addElement((ASN1Value)ecPublivKey);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            outer.encode((OutputStream)baos);
        }
        catch (IOException ioe) {
            throw new RuntimeException("Internal ASN.1 encoding error", ioe);
        }
        return baos.toByteArray();
    }

    @Override
    public String getFormat() {
        return "X.509";
    }

    @Override
    public ECParameterSpec getParams() {
        return this.params;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        int bitlen = this.params.getOrder().bitLength();
        sb.append("GooKey EC public key, " + bitlen + " bit\n");
        sb.append("  Public value (x coordinate): " + this.x.toString(16) + "\n");
        sb.append("  Public value (y coordinate): " + this.y.toString(16) + "\n");
        sb.append("  Parameters: " + EcCore.getFriendlyName(this.params) + " (" + EcCore.getOID(this.params) + ")");
        return sb.toString();
    }
}

