/*
 * Decompiled with CFR 0.152.
 */
package org.keyczar.jce;

import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.SecureRandom;
import java.security.spec.ECParameterSpec;
import org.keyczar.jce.EcCore;
import org.keyczar.jce.EcPrivateKeyImpl;
import org.keyczar.jce.EcPublicKeyImpl;

public class EcKeyPairGeneratorImpl
extends KeyPairGeneratorSpi {
    private ECParameterSpec params;

    @Override
    public KeyPair generateKeyPair() {
        BigInteger n = this.params.getOrder();
        BigInteger S = BigInteger.ZERO;
        while ((S = new BigInteger(n.bitLength(), new SecureRandom()).mod(n)).signum() == 0) {
        }
        BigInteger[] G = EcCore.internalPoint(this.params.getGenerator());
        BigInteger[] Q = EcCore.multiplyPoint(G, S, this.params);
        EcCore.toAffine(Q, this.params);
        return new KeyPair(new EcPublicKeyImpl(Q[0], Q[1], this.params), new EcPrivateKeyImpl(S, this.params));
    }

    @Override
    public void initialize(int keysize, SecureRandom random) {
        switch (keysize) {
            case 192: {
                this.params = EcCore.getParams("1.2.840.10045.3.1.1");
                break;
            }
            case 224: {
                this.params = EcCore.getParams("1.3.132.0.33");
                break;
            }
            case 256: {
                this.params = EcCore.getParams("1.2.840.10045.3.1.7");
                break;
            }
            case 384: {
                this.params = EcCore.getParams("1.3.132.0.34");
                break;
            }
            case 521: {
                this.params = EcCore.getParams("1.3.132.0.35");
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported keysize: " + keysize);
            }
        }
    }
}

