/*
 * Decompiled with CFR 0.152.
 */
package org.keyczar.experimental;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.TreeSet;
import org.keyczar.Signer;
import org.keyczar.annotations.Experimental;
import org.keyczar.exceptions.KeyczarException;
import org.keyczar.interfaces.KeyczarReader;

@Experimental
public class UriSigner {
    private static final String DEFAULT_SIG_PARAM = "sig";
    private Signer signer;

    public UriSigner(KeyczarReader reader) throws KeyczarException {
        this.signer = new Signer(reader);
    }

    public UriSigner(String fileLocation) throws KeyczarException {
        this.signer = new Signer(fileLocation);
    }

    public URI sign(URI uri) throws KeyczarException {
        return this.sign(uri, DEFAULT_SIG_PARAM);
    }

    public URI sign(URI uri, String sigParam) throws KeyczarException {
        try {
            uri = this.canonicalUri(uri);
        }
        catch (URISyntaxException e) {
            throw new KeyczarException(e);
        }
        String uriString = uri.toASCIIString();
        String sig = this.signer.sign(uriString);
        String signedQuery = String.valueOf(sigParam) + "=" + sig;
        String query = uri.getQuery();
        if (query != null) {
            signedQuery = String.valueOf(query) + "&" + signedQuery;
        }
        try {
            return new URI(uri.getScheme(), uri.getAuthority(), uri.getPath(), signedQuery, uri.getFragment());
        }
        catch (URISyntaxException e) {
            throw new KeyczarException(e);
        }
    }

    public boolean verify(URI signedUri) throws KeyczarException {
        return this.verify(signedUri, DEFAULT_SIG_PARAM);
    }

    public boolean verify(URI signedUri, String sigParam) throws KeyczarException {
        if (signedUri == null) {
            return false;
        }
        String query = signedUri.getQuery();
        if (query == null) {
            return false;
        }
        String sig = null;
        StringBuffer unsignedQuery = new StringBuffer();
        String[] stringArray = query.split("&");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String param = stringArray[n2];
            if (param.startsWith(sigParam)) {
                String[] nameValue = param.split("=");
                if (nameValue.length == 2) {
                    sig = nameValue[1];
                }
            } else {
                unsignedQuery.append(param).append('&');
            }
            ++n2;
        }
        if (sig == null) {
            return false;
        }
        try {
            URI unsignedUri;
            if (unsignedQuery.length() > 0) {
                unsignedQuery.deleteCharAt(unsignedQuery.length() - 1);
                unsignedUri = new URI(signedUri.getScheme(), signedUri.getAuthority(), signedUri.getPath(), unsignedQuery.toString(), signedUri.getFragment());
            } else {
                unsignedUri = new URI(signedUri.getScheme(), signedUri.getAuthority(), signedUri.getPath(), null, signedUri.getFragment());
            }
            unsignedUri = this.canonicalUri(unsignedUri);
            return this.signer.verify(unsignedUri.toASCIIString(), sig);
        }
        catch (URISyntaxException e) {
            return false;
        }
    }

    private String canonicalQuery(String query) {
        StringBuffer canonicalQuery = new StringBuffer();
        TreeSet<String> params = new TreeSet<String>();
        if (query != null) {
            String[] nameValues;
            String[] stringArray = nameValues = query.split("&");
            int n = nameValues.length;
            int n2 = 0;
            while (n2 < n) {
                String nameValue = stringArray[n2];
                params.add(nameValue);
                ++n2;
            }
            for (String nameValue : params) {
                canonicalQuery.append(nameValue).append('&');
            }
            canonicalQuery.deleteCharAt(canonicalQuery.length() - 1);
        }
        return canonicalQuery.toString();
    }

    private URI canonicalUri(URI uri) throws URISyntaxException {
        return uri == null ? null : new URI(uri.getScheme(), uri.getAuthority(), uri.getPath(), this.canonicalQuery(uri.getQuery()), uri.getFragment());
    }
}

