/*
 * Decompiled with CFR 0.152.
 */
package org.keyczar.enums;

import org.keyczar.i18n.Messages;

public enum Flag {
    LOCATION("location"),
    NAME("name"),
    SIZE("size"),
    STATUS("status"),
    PURPOSE("purpose"),
    DESTINATION("destination"),
    VERSION("version"),
    ASYMMETRIC("asymmetric"),
    CRYPTER("crypter");

    private final String name;

    private Flag(String name) {
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    public static Flag getFlag(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        if (name.equalsIgnoreCase(LOCATION.toString())) {
            return LOCATION;
        }
        if (name.equalsIgnoreCase(NAME.toString())) {
            return NAME;
        }
        if (name.equalsIgnoreCase(SIZE.toString())) {
            return SIZE;
        }
        if (name.equalsIgnoreCase(STATUS.toString())) {
            return STATUS;
        }
        if (name.equalsIgnoreCase(PURPOSE.toString())) {
            return PURPOSE;
        }
        if (name.equalsIgnoreCase(DESTINATION.toString())) {
            return DESTINATION;
        }
        if (name.equalsIgnoreCase(VERSION.toString())) {
            return VERSION;
        }
        if (name.equalsIgnoreCase(ASYMMETRIC.toString())) {
            return ASYMMETRIC;
        }
        if (name.equalsIgnoreCase(CRYPTER.toString())) {
            return CRYPTER;
        }
        throw new IllegalArgumentException(Messages.getString("Flag.UnknownFlag", name));
    }
}

