/*
 * Decompiled with CFR 0.152.
 */
package org.keyczar.enums;

import org.keyczar.i18n.Messages;

public enum Command {
    CREATE("create"),
    ADDKEY("addkey"),
    PUBKEY("pubkey"),
    PROMOTE("promote"),
    DEMOTE("demote"),
    REVOKE("revoke"),
    USEKEY("usekey");

    private final String name;

    private Command(String name) {
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    public static Command getCommand(String command) {
        if (command == null) {
            throw new NullPointerException();
        }
        if (command.equalsIgnoreCase(CREATE.toString())) {
            return CREATE;
        }
        if (command.equalsIgnoreCase(ADDKEY.toString())) {
            return ADDKEY;
        }
        if (command.equalsIgnoreCase(PUBKEY.toString())) {
            return PUBKEY;
        }
        if (command.equalsIgnoreCase(PROMOTE.toString())) {
            return PROMOTE;
        }
        if (command.equalsIgnoreCase(DEMOTE.toString())) {
            return DEMOTE;
        }
        if (command.equalsIgnoreCase(REVOKE.toString())) {
            return REVOKE;
        }
        if (command.equalsIgnoreCase(USEKEY.toString())) {
            return USEKEY;
        }
        throw new IllegalArgumentException(Messages.getString("Command.UnknownCommand", command));
    }
}

