/*
 * Decompiled with CFR 0.152.
 */
package org.keyczar;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import org.apache.log4j.Logger;
import org.keyczar.KeyczarKey;
import org.keyczar.StreamQueue;
import org.keyczar.Verifier;
import org.keyczar.enums.KeyPurpose;
import org.keyczar.exceptions.KeyczarException;
import org.keyczar.exceptions.NoPrimaryKeyException;
import org.keyczar.exceptions.ShortBufferException;
import org.keyczar.i18n.Messages;
import org.keyczar.interfaces.KeyczarReader;
import org.keyczar.interfaces.SigningStream;
import org.keyczar.util.Base64Coder;
import org.keyczar.util.Util;

public class Signer
extends Verifier {
    static final int TIMESTAMP_SIZE = 8;
    private static final Logger SIGNER_LOGGER = Logger.getLogger(Signer.class);
    private final StreamQueue<SigningStream> SIGN_QUEUE = new StreamQueue();

    public Signer(KeyczarReader reader) throws KeyczarException {
        super(reader);
    }

    public Signer(String fileLocation) throws KeyczarException {
        super(fileLocation);
    }

    public int digestSize() throws KeyczarException {
        KeyczarKey signingKey = this.getPrimaryKey();
        if (signingKey == null) {
            throw new NoPrimaryKeyException();
        }
        return 5 + ((SigningStream)signingKey.getStream()).digestSize();
    }

    public byte[] sign(byte[] input) throws KeyczarException {
        ByteBuffer output = ByteBuffer.allocate(this.digestSize());
        this.sign(ByteBuffer.wrap(input), output);
        output.reset();
        byte[] outputBytes = new byte[output.remaining()];
        output.get(outputBytes);
        return outputBytes;
    }

    public void sign(ByteBuffer input, ByteBuffer output) throws KeyczarException {
        this.sign(input, null, 0L, output);
    }

    void sign(ByteBuffer input, ByteBuffer hidden, long expirationTime, ByteBuffer output) throws KeyczarException {
        SIGNER_LOGGER.info((Object)Messages.getString("Signer.Signing", input.remaining()));
        KeyczarKey signingKey = this.getPrimaryKey();
        if (signingKey == null) {
            throw new NoPrimaryKeyException();
        }
        SigningStream stream = (SigningStream)this.SIGN_QUEUE.poll();
        if (stream == null) {
            stream = (SigningStream)signingKey.getStream();
        }
        int spaceNeeded = this.digestSize();
        if (expirationTime > 0L) {
            spaceNeeded += 8;
        }
        if (output.capacity() < spaceNeeded) {
            throw new ShortBufferException(output.capacity(), spaceNeeded);
        }
        ByteBuffer header = ByteBuffer.allocate(5);
        signingKey.copyHeader(header);
        header.rewind();
        stream.initSign();
        output.mark();
        output.put(header);
        if (expirationTime > 0L) {
            ByteBuffer expiration = ByteBuffer.wrap(Util.fromLong(expirationTime));
            output.put(expiration);
            expiration.rewind();
            stream.updateSign(expiration);
        }
        if (hidden != null && hidden.remaining() > 0) {
            stream.updateSign(hidden);
        }
        stream.updateSign(input);
        stream.updateSign(ByteBuffer.wrap(FORMAT_BYTES));
        stream.sign(output);
        output.limit(output.position());
        this.SIGN_QUEUE.add(stream);
    }

    public String sign(String input) throws KeyczarException {
        try {
            return Base64Coder.encode(this.sign(input.getBytes("UTF-8")));
        }
        catch (UnsupportedEncodingException e) {
            throw new KeyczarException(e);
        }
    }

    @Override
    boolean isAcceptablePurpose(KeyPurpose purpose) {
        return purpose == KeyPurpose.SIGN_AND_VERIFY;
    }
}

