/*
 * Decompiled with CFR 0.152.
 */
package org.keyczar;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import org.keyczar.Encrypter;
import org.keyczar.KeyMetadata;
import org.keyczar.KeyVersion;
import org.keyczar.Keyczar;
import org.keyczar.KeyczarKey;
import org.keyczar.KeyczarPrivateKey;
import org.keyczar.KeyczarPublicKey;
import org.keyczar.KeyczarTool;
import org.keyczar.enums.KeyPurpose;
import org.keyczar.enums.KeyStatus;
import org.keyczar.enums.KeyType;
import org.keyczar.exceptions.KeyczarException;
import org.keyczar.i18n.Messages;
import org.keyczar.interfaces.KeyczarReader;

class GenericKeyczar
extends Keyczar {
    GenericKeyczar(KeyczarReader reader) throws KeyczarException {
        super(reader);
    }

    GenericKeyczar(String location) throws KeyczarException {
        super(location);
    }

    @Override
    boolean isAcceptablePurpose(KeyPurpose purpose) {
        return true;
    }

    KeyMetadata getMetadata() {
        return this.kmd;
    }

    Set<KeyVersion> getVersions() {
        return Collections.unmodifiableSet(this.versionMap.keySet());
    }

    KeyczarKey getKey(KeyVersion v) {
        return (KeyczarKey)this.versionMap.get(v);
    }

    void promote(int versionNumber) throws KeyczarException {
        KeyVersion version = this.getVersion(versionNumber);
        KEYCZAR_LOGGER.info((Object)Messages.getString("Keyczar.PromotedVersion", version));
        switch (version.getStatus()) {
            case PRIMARY: {
                throw new KeyczarException(Messages.getString("Keyczar.CantPromotePrimary", new Object[0]));
            }
            case ACTIVE: {
                version.setStatus(KeyStatus.PRIMARY);
                if (this.primaryVersion != null) {
                    this.primaryVersion.setStatus(KeyStatus.ACTIVE);
                }
                this.primaryVersion = version;
                break;
            }
            case INACTIVE: {
                version.setStatus(KeyStatus.ACTIVE);
            }
        }
    }

    void demote(int versionNumber) throws KeyczarException {
        KeyVersion version = this.getVersion(versionNumber);
        KEYCZAR_LOGGER.info((Object)Messages.getString("Keyczar.DemotingVersion", version));
        switch (version.getStatus()) {
            case PRIMARY: {
                version.setStatus(KeyStatus.ACTIVE);
                this.primaryVersion = null;
                break;
            }
            case ACTIVE: {
                version.setStatus(KeyStatus.INACTIVE);
                break;
            }
            case INACTIVE: {
                throw new KeyczarException(Messages.getString("Keyczar.CantDemoteScheduled", new Object[0]));
            }
        }
    }

    void addVersion(KeyStatus status) throws KeyczarException {
        this.addVersion(status, this.kmd.getType().defaultSize());
    }

    void addVersion(KeyStatus status, int keySize) throws KeyczarException {
        KeyczarKey key;
        KeyVersion version = new KeyVersion(this.numVersions() + 1, status, false);
        if (status == KeyStatus.PRIMARY) {
            if (this.primaryVersion != null) {
                this.primaryVersion.setStatus(KeyStatus.ACTIVE);
            }
            this.primaryVersion = version;
        }
        if (keySize < this.kmd.getType().defaultSize()) {
            KEYCZAR_LOGGER.warn((Object)Messages.getString("Keyczar.SizeWarning", keySize, this.kmd.getType().defaultSize(), this.kmd.getType().toString()));
        }
        while (this.getKey((key = KeyczarKey.genKey(this.kmd.getType(), keySize)).hash()) != null) {
        }
        this.addKey(version, key);
        KEYCZAR_LOGGER.info((Object)Messages.getString("Keyczar.NewVersion", version));
    }

    int numVersions() {
        return this.versionMap.size();
    }

    KeyVersion getVersion(int versionNumber) throws KeyczarException {
        KeyVersion version = this.kmd.getVersion(versionNumber);
        if (version == null) {
            throw new KeyczarException(Messages.getString("Keyczar.NoSuchVersion", versionNumber));
        }
        return version;
    }

    void revoke(int versionNumber) throws KeyczarException {
        KeyVersion version = this.getVersion(versionNumber);
        if (version.getStatus() != KeyStatus.INACTIVE) {
            throw new KeyczarException(Messages.getString("Keyczar.CantRevoke", new Object[0]));
        }
        this.kmd.removeVersion(versionNumber);
    }

    void publicKeyExport(String destination) throws KeyczarException {
        if (destination != null && !destination.endsWith(File.separator)) {
            destination = String.valueOf(destination) + File.separator;
        }
        KeyMetadata kmd = this.getMetadata();
        KeyMetadata publicKmd = null;
        block0 : switch (kmd.getType()) {
            case DSA_PRIV: {
                if (kmd.getPurpose() != KeyPurpose.SIGN_AND_VERIFY) break;
                publicKmd = new KeyMetadata(kmd.getName(), KeyPurpose.VERIFY, KeyType.DSA_PUB);
                break;
            }
            case RSA_PRIV: {
                switch (kmd.getPurpose()) {
                    case DECRYPT_AND_ENCRYPT: {
                        publicKmd = new KeyMetadata(kmd.getName(), KeyPurpose.ENCRYPT, KeyType.RSA_PUB);
                        break block0;
                    }
                    case SIGN_AND_VERIFY: {
                        publicKmd = new KeyMetadata(kmd.getName(), KeyPurpose.VERIFY, KeyType.RSA_PUB);
                    }
                }
            }
        }
        if (publicKmd == null) {
            throw new KeyczarException(Messages.getString("KeyczarTool.CannotExportPubKey", new Object[]{kmd.getType(), kmd.getPurpose()}));
        }
        for (KeyVersion version : this.getVersions()) {
            KeyczarPublicKey publicKey = ((KeyczarPrivateKey)((Object)this.getKey(version))).getPublic();
            if (KeyczarTool.getMock() == null) {
                this.writeFile(publicKey.toString(), String.valueOf(destination) + version.getVersionNumber());
            } else {
                KeyczarTool.getMock().setPublicKey(version.getVersionNumber(), publicKey);
            }
            publicKmd.addVersion(version);
        }
        if (KeyczarTool.getMock() == null) {
            this.writeFile(publicKmd.toString(), String.valueOf(destination) + "meta");
        } else {
            KeyczarTool.getMock().setPublicKeyMetadata(publicKmd);
        }
    }

    void write(String location) throws KeyczarException {
        this.writeFile(this.kmd.toString(), String.valueOf(location) + "meta");
        for (KeyVersion version : this.getVersions()) {
            this.writeFile(this.getKey(version).toString(), String.valueOf(location) + version.getVersionNumber());
        }
    }

    void writeEncrypted(String location, Encrypter encrypter) throws KeyczarException {
        KeyMetadata kmd = this.getMetadata();
        kmd.setEncrypted(true);
        this.writeFile(kmd.toString(), String.valueOf(location) + "meta");
        for (KeyVersion version : this.getVersions()) {
            this.writeFile(encrypter.encrypt(this.getKey(version).toString()), String.valueOf(location) + version.getVersionNumber());
        }
    }

    void writeFile(String data, String location) throws KeyczarException {
        File outputFile = new File(location);
        try {
            FileWriter writer = new FileWriter(outputFile);
            writer.write(data);
            writer.close();
        }
        catch (IOException e) {
            throw new KeyczarException(Messages.getString("KeyczarTool.UnableToWrite", outputFile.toString()), e);
        }
    }
}

