/*
 * Decompiled with CFR 0.152.
 */
package org.keyczar;

import com.google.gson.annotations.Expose;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.X509EncodedKeySpec;
import org.keyczar.KeyczarPublicKey;
import org.keyczar.enums.KeyType;
import org.keyczar.exceptions.KeyczarException;
import org.keyczar.interfaces.Stream;
import org.keyczar.interfaces.VerifyingStream;
import org.keyczar.util.Base64Coder;
import org.keyczar.util.Util;

class EcPublicKey
extends KeyczarPublicKey {
    private static final String KEY_GEN_ALGORITHM = "EC";
    private static final String SIG_ALGORITHM = "SHA256withECDSA";
    private PublicKey jcePublicKey;
    @Expose
    String x509;
    private byte[] hash = new byte[4];

    EcPublicKey() {
    }

    void init() throws KeyczarException {
        byte[] x509Bytes = Base64Coder.decode(this.x509);
        try {
            KeyFactory kf = KeyFactory.getInstance(KEY_GEN_ALGORITHM);
            this.jcePublicKey = kf.generatePublic(new X509EncodedKeySpec(x509Bytes));
            byte[] fullHash = Util.prefixHash(new byte[][]{x509Bytes});
            System.arraycopy(fullHash, 0, this.hash, 0, this.hash.length);
        }
        catch (GeneralSecurityException e) {
            throw new KeyczarException(e);
        }
    }

    void set(byte[] x509Bytes) throws KeyczarException {
        this.x509 = Base64Coder.encode(x509Bytes);
        byte[] fullHash = Util.prefixHash(new byte[][]{x509Bytes});
        System.arraycopy(fullHash, 0, this.hash, 0, this.hash.length);
        this.init();
    }

    @Override
    byte[] hash() {
        return this.hash;
    }

    @Override
    public Stream getStream() throws KeyczarException {
        return new EcVerifyingStream();
    }

    @Override
    KeyType getType() {
        return KeyType.EC_PUB;
    }

    static EcPublicKey read(String input) throws KeyczarException {
        EcPublicKey key = (EcPublicKey)Util.gson().fromJson(input, EcPublicKey.class);
        key.init();
        return key;
    }

    private class EcVerifyingStream
    implements VerifyingStream {
        private Signature signature;

        public EcVerifyingStream() throws KeyczarException {
            try {
                this.signature = Signature.getInstance(EcPublicKey.SIG_ALGORITHM);
            }
            catch (GeneralSecurityException e) {
                throw new KeyczarException(e);
            }
        }

        @Override
        public int digestSize() {
            return EcPublicKey.this.getType().getOutputSize();
        }

        @Override
        public void initVerify() throws KeyczarException {
            try {
                this.signature.initVerify(EcPublicKey.this.jcePublicKey);
            }
            catch (GeneralSecurityException e) {
                throw new KeyczarException(e);
            }
        }

        @Override
        public void updateVerify(ByteBuffer input) throws KeyczarException {
            try {
                this.signature.update(input);
            }
            catch (SignatureException e) {
                throw new KeyczarException(e);
            }
        }

        @Override
        public boolean verify(ByteBuffer sig) throws KeyczarException {
            try {
                return this.signature.verify(sig.array(), sig.position(), sig.limit() - sig.position());
            }
            catch (GeneralSecurityException e) {
                throw new KeyczarException(e);
            }
        }
    }
}

