/*
 * Decompiled with CFR 0.152.
 */
package org.keyczar;

import com.google.gson.annotations.Expose;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.DSAPublicKeySpec;
import org.keyczar.KeyczarPublicKey;
import org.keyczar.enums.KeyType;
import org.keyczar.exceptions.KeyczarException;
import org.keyczar.interfaces.Stream;
import org.keyczar.interfaces.VerifyingStream;
import org.keyczar.util.Base64Coder;
import org.keyczar.util.Util;

class DsaPublicKey
extends KeyczarPublicKey {
    private static final String KEY_GEN_ALGORITHM = "DSA";
    private static final String SIG_ALGORITHM = "SHA1withDSA";
    private PublicKey jcePublicKey;
    @Expose
    String y;
    @Expose
    String p;
    @Expose
    String q;
    @Expose
    String g;
    private byte[] hash = new byte[4];

    DsaPublicKey() {
    }

    @Override
    public Stream getStream() throws KeyczarException {
        return new DsaVerifyingStream();
    }

    @Override
    KeyType getType() {
        return KeyType.DSA_PUB;
    }

    static DsaPublicKey read(String input) throws KeyczarException {
        DsaPublicKey key = (DsaPublicKey)Util.gson().fromJson(input, DsaPublicKey.class);
        key.init();
        return key;
    }

    @Override
    public byte[] hash() {
        return this.hash;
    }

    void set(BigInteger yVal, BigInteger pVal, BigInteger qVal, BigInteger gVal) throws KeyczarException {
        this.y = Base64Coder.encode(yVal.toByteArray());
        this.p = Base64Coder.encode(pVal.toByteArray());
        this.q = Base64Coder.encode(qVal.toByteArray());
        this.g = Base64Coder.encode(gVal.toByteArray());
        this.init();
    }

    void init() throws KeyczarException {
        BigInteger yVal = new BigInteger(Base64Coder.decode(this.y));
        BigInteger pVal = new BigInteger(Base64Coder.decode(this.p));
        BigInteger qVal = new BigInteger(Base64Coder.decode(this.q));
        BigInteger gVal = new BigInteger(Base64Coder.decode(this.g));
        DSAPublicKeySpec spec = new DSAPublicKeySpec(yVal, pVal, qVal, gVal);
        try {
            KeyFactory kf = KeyFactory.getInstance(KEY_GEN_ALGORITHM);
            this.jcePublicKey = kf.generatePublic(spec);
        }
        catch (GeneralSecurityException e) {
            throw new KeyczarException(e);
        }
        byte[] fullHash = Util.prefixHash(Util.stripLeadingZeros(pVal.toByteArray()), Util.stripLeadingZeros(qVal.toByteArray()), Util.stripLeadingZeros(gVal.toByteArray()), Util.stripLeadingZeros(yVal.toByteArray()));
        System.arraycopy(fullHash, 0, this.hash, 0, this.hash.length);
    }

    private class DsaVerifyingStream
    implements VerifyingStream {
        private Signature signature;

        public DsaVerifyingStream() throws KeyczarException {
            try {
                this.signature = Signature.getInstance(DsaPublicKey.SIG_ALGORITHM);
            }
            catch (GeneralSecurityException e) {
                throw new KeyczarException(e);
            }
        }

        @Override
        public int digestSize() {
            return DsaPublicKey.this.getType().getOutputSize();
        }

        @Override
        public void initVerify() throws KeyczarException {
            try {
                this.signature.initVerify(DsaPublicKey.this.jcePublicKey);
            }
            catch (GeneralSecurityException e) {
                throw new KeyczarException(e);
            }
        }

        @Override
        public void updateVerify(ByteBuffer input) throws KeyczarException {
            try {
                this.signature.update(input);
            }
            catch (SignatureException e) {
                throw new KeyczarException(e);
            }
        }

        @Override
        public boolean verify(ByteBuffer sig) throws KeyczarException {
            try {
                return this.signature.verify(sig.array(), sig.position(), sig.limit() - sig.position());
            }
            catch (GeneralSecurityException e) {
                throw new KeyczarException(e);
            }
        }
    }
}

