'use strict';

const cssTree = require('css-tree');

const ATRULE = cssTree.tokenTypes.AtKeyword;
const COMMERCIALAT = 0x0040; // U+0040 COMMERCIAL AT (@)

const name = 'LessVariableReference';
const structure = {
    name: 'Identifier'
};
function parse() {
    const start = this.tokenStart;

    this.eatDelim(COMMERCIALAT);
    this.eat(ATRULE);

    return {
        type: 'LessVariableReference',
        loc: this.getLocation(start, this.tokenEnd),
        name: this.substrToCursor(start + 2)
    };
}

exports.name = name;
exports.parse = parse;
exports.structure = structure;
