#!/bin/bash
set -euox pipefail

unset GREP_OPTIONS

compatbranches=$(hg branches --quiet | grep 'mercurial-' | grep -v ':' | sort -n --reverse)
prev='stable'
topic=${1:-'test-compat'}
for branch in $compatbranches; do
    # Logic in the revsets below:
    # 1. There is target topic on stable or compatibility branch: merge all
    # those commits, they are related to our work and need to pass tests on all
    # compatibility branches.
    # 2. There is no target topic: avoid any commits that have topic set, they
    # are definitely unrelated to what we're doing.
    # In other words, if you want to test certain commits, assign them all to
    # one topic and provide that topic as the first argument to this script.
    uptarget="first(max(branch('$branch') and topic('$topic')) or max(branch('$branch') and not topic()))"
    hg up -r "$uptarget"
    hg topic "$topic"
    mergetarget="first(max(branch('$prev') and topic('$topic')) or max(branch('$prev') and not topic()))"
    hg merge -r "$mergetarget"
    hg commit -m "test-compat: merge $prev into $branch"
    prev=$branch
done
