This test file test the various messages when accessing obsolete
revisions.

Global setup
============

  $ . $TESTDIR/testlib/obshistory_setup.sh

Test output with splitted commit
================================

Test setup
----------

  $ hg init $TESTTMP/local-split
  $ hg init $TESTTMP/server
  $ cd $TESTTMP/local-split
  $ mkcommit ROOT
  $ sync
  $ echo 42 >> a
  $ echo 43 >> b
  $ hg commit -A -m "A0"
  adding a
  adding b
  $ hg log --hidden -G
  @  changeset:   1:471597cad322
  |  tag:         tip
  |  user:        test
  |  date:        Thu Jan 01 00:00:00 1970 +0000
  |  summary:     A0
  |
  o  changeset:   0:ea207398892e
     user:        test
     date:        Thu Jan 01 00:00:00 1970 +0000
     summary:     ROOT
  
  $ hg split -r 'desc(A0)' -n "testing split" -d "0 0" << EOF
  > y
  > y
  > n
  > n
  > y
  > y
  > EOF
  0 files updated, 0 files merged, 2 files removed, 0 files unresolved
  adding a
  adding b
  diff --git a/a b/a
  new file mode 100644
  examine changes to 'a'? [Ynesfdaq?] y
  
  @@ -0,0 +1,1 @@
  +42
  record change 1/2 to 'a'? [Ynesfdaq?] y
  
  diff --git a/b b/b
  new file mode 100644
  examine changes to 'b'? [Ynesfdaq?] n
  
  created new head
  Done splitting? [yN] n
  diff --git a/b b/b
  new file mode 100644
  examine changes to 'b'? [Ynesfdaq?] y
  
  @@ -0,0 +1,1 @@
  +43
  record this change to 'b'? [Ynesfdaq?] y
  
  no more change to split

  $ sync

  $ hg log --hidden -G
  @  changeset:   3:f257fde29c7a
  |  tag:         tip
  |  user:        test
  |  date:        Thu Jan 01 00:00:00 1970 +0000
  |  summary:     A0
  |
  o  changeset:   2:337fec4d2edc
  |  parent:      0:ea207398892e
  |  user:        test
  |  date:        Thu Jan 01 00:00:00 1970 +0000
  |  summary:     A0
  |
  | x  changeset:   1:471597cad322
  |/   user:        test
  |    date:        Thu Jan 01 00:00:00 1970 +0000
  |    obsolete:    split using split as 2:337fec4d2edc, 3:f257fde29c7a
  |    summary:     A0
  |
  o  changeset:   0:ea207398892e
     user:        test
     date:        Thu Jan 01 00:00:00 1970 +0000
     summary:     ROOT
  
Check output on the client side
-------------------------------

Check that debugobshistory on splitted commit show both targets
  $ hg obslog 471597cad322 --hidden --patch
  x  471597cad322 (1) A0
       rewritten(parent, content) as 337fec4d2edc, f257fde29c7a using split by test (Thu Jan 01 00:00:00 1970 +0000)
         note: testing split
         (No patch available, too many successors (2))
  
  $ hg obslog 471597cad322 --hidden --no-graph -Tjson | python -m json.tool
  [
      {
          "markers": [
              {
                  "date": [
                      *, (glob)
                      0 (glob)
                  ],
                  "effect": [
                      "parent",
                      "content"
                  ],
                  "note": "testing split",
                  "operation": "split",
                  "succnodes": [
                      "337fec4d2edc",
                      "f257fde29c7a"
                  ],
                  "user": "test",
                  "verb": "rewritten"
              }
          ],
          "node": "471597cad322",
          "rev": 1,
          "shortdescription": "A0"
      }
  ]
Check that debugobshistory on the first successor after split show
the revision plus the splitted one
  $ hg obslog 337fec4d2edc --patch
  o  337fec4d2edc (2) A0
  |
  x  471597cad322 (1) A0
       rewritten(parent, content) as 337fec4d2edc, f257fde29c7a using split by test (Thu Jan 01 00:00:00 1970 +0000)
         note: testing split
         (No patch available, too many successors (2))
  
With the all option, it should show the three changesets
  $ hg obslog --all 337fec4d2edc --patch
  o  337fec4d2edc (2) A0
  |
  | @  f257fde29c7a (3) A0
  |/
  x  471597cad322 (1) A0
       rewritten(parent, content) as 337fec4d2edc, f257fde29c7a using split by test (Thu Jan 01 00:00:00 1970 +0000)
         note: testing split
         (No patch available, too many successors (2))
  
Check that debugobshistory on the second successor after split show
the revision plus the splitted one
  $ hg obslog f257fde29c7a --patch
  @  f257fde29c7a (3) A0
  |
  x  471597cad322 (1) A0
       rewritten(parent, content) as 337fec4d2edc, f257fde29c7a using split by test (Thu Jan 01 00:00:00 1970 +0000)
         note: testing split
         (No patch available, too many successors (2))
  
With the all option, it should show the three changesets
  $ hg obslog f257fde29c7a --all --patch
  o  337fec4d2edc (2) A0
  |
  | @  f257fde29c7a (3) A0
  |/
  x  471597cad322 (1) A0
       rewritten(parent, content) as 337fec4d2edc, f257fde29c7a using split by test (Thu Jan 01 00:00:00 1970 +0000)
         note: testing split
         (No patch available, too many successors (2))
  
Obslog with all option all should also works on the splitted commit
  $ hg obslog -a 471597cad322 --hidden --patch
  o  337fec4d2edc (2) A0
  |
  | @  f257fde29c7a (3) A0
  |/
  x  471597cad322 (1) A0
       rewritten(parent, content) as 337fec4d2edc, f257fde29c7a using split by test (Thu Jan 01 00:00:00 1970 +0000)
         note: testing split
         (No patch available, too many successors (2))
  
Check that debugobshistory on both successors after split show
a coherent graph
  $ hg obslog 'f257fde29c7a+337fec4d2edc' --patch
  o  337fec4d2edc (2) A0
  |
  | @  f257fde29c7a (3) A0
  |/
  x  471597cad322 (1) A0
       rewritten(parent, content) as 337fec4d2edc, f257fde29c7a using split by test (Thu Jan 01 00:00:00 1970 +0000)
         note: testing split
         (No patch available, too many successors (2))
  
  $ hg update 471597cad322
  abort: hidden revision '471597cad322' was split as: 337fec4d2edc, f257fde29c7a!
  (use --hidden to access hidden revisions)
  [255]
  $ hg update --hidden 'min(desc(A0))'
  0 files updated, 0 files merged, 0 files removed, 0 files unresolved
  updated to hidden changeset 471597cad322
  (hidden revision '471597cad322' was split as: 337fec4d2edc, f257fde29c7a)
  working directory parent is obsolete! (471597cad322)
  (use 'hg evolve' to update to its tipmost successor: 337fec4d2edc, f257fde29c7a)

Check output on the server side
-------------------------------

  $ hg obslog -R $TESTTMP/server --patch tip
  o  f257fde29c7a (2) A0
  |
  x  471597cad322
       rewritten(parent, content) as 337fec4d2edc, f257fde29c7a using split by test (Thu Jan 01 00:00:00 1970 +0000)
         note: testing split
         (No patch available, context is not local)
  
  $ hg obslog -R $TESTTMP/server -f --patch tip
  o  f257fde29c7a (2) A0
  
  $ hg obslog -R $TESTTMP/server --all --patch tip
  o  337fec4d2edc (1) A0
  |
  | o  f257fde29c7a (2) A0
  |/
  x  471597cad322
       rewritten(parent, content) as 337fec4d2edc, f257fde29c7a using split by test (Thu Jan 01 00:00:00 1970 +0000)
         note: testing split
         (No patch available, context is not local)
  
  $ hg obslog -R $TESTTMP/server --all -f --patch tip
  o  337fec4d2edc (1) A0
  
  o  f257fde29c7a (2) A0
  
  $ hg obslog -R $TESTTMP/server --no-graph -f --all --patch tip
  f257fde29c7a (2) A0
  471597cad322
    rewritten(parent, content) as 337fec4d2edc, f257fde29c7a using split by test (Thu Jan 01 00:00:00 1970 +0000)
      note: testing split
      (No patch available, context is not local)

  $ hg obslog -R $TESTTMP/server --no-graph -f --all --patch tip
  f257fde29c7a (2) A0
  471597cad322
    rewritten(parent, content) as 337fec4d2edc, f257fde29c7a using split by test (Thu Jan 01 00:00:00 1970 +0000)
      note: testing split
      (No patch available, context is not local)
